/*
 * Decompiled with CFR 0.152.
 */
package net.domesdaybook.automata;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.domesdaybook.automata.State;
import net.domesdaybook.automata.Transition;

public class Utilities {
    private Utilities() {
    }

    public static List<State> getFinalStates(State initialState) {
        HashSet<State> visitedStates = new HashSet<State>();
        ArrayList<State> finalStates = new ArrayList<State>();
        Utilities.getAllFinalStates(initialState, visitedStates, finalStates);
        return finalStates;
    }

    private static void getAllFinalStates(State state, Set<State> visitedStates, List<State> finalStates) {
        if (!visitedStates.contains(state)) {
            visitedStates.add(state);
            if (state.isFinal()) {
                finalStates.add(state);
            }
            List<Transition> transitions = state.getTransitions();
            for (Transition transition : transitions) {
                Utilities.getAllFinalStates(transition.getToState(), visitedStates, finalStates);
            }
        }
    }

    public static String toDot(State initialState, String title) {
        StringBuilder builder = new StringBuilder();
        builder.append("digraph {\n");
        builder.append(String.format("label=\"%s\"\n", title));
        HashSet<State> visitedStates = new HashSet<State>();
        Utilities.buildDot(initialState, visitedStates, builder);
        builder.append("\n}");
        return builder.toString();
    }

    private static void buildDot(State state, Set<State> visitedStates, StringBuilder builder) {
        if (!visitedStates.contains(state)) {
            visitedStates.add(state);
            String label = state.getLabel();
            String shape = state.isFinal() ? "doublecircle" : "circle";
            builder.append(String.format("%s [label=\"%s\", shape=\"%s\"]\n", label, label, shape));
            List<Transition> transitions = state.getTransitions();
            for (Transition transition : transitions) {
                State toState = transition.getToState();
                Utilities.buildDot(toState, visitedStates, builder);
                String toStateLabel = toState.getLabel();
                String transitionLabel = transition.toString();
                builder.append(String.format("%s->%s [label=\"%s\"]\n", label, toStateLabel, transitionLabel));
            }
        }
    }
}

