/*
 * Decompiled with CFR 0.152.
 */
package net.domesdaybook.automata.labeler;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.domesdaybook.automata.State;
import net.domesdaybook.automata.Transition;
import net.domesdaybook.automata.labeler.StateCountLabeler;
import net.domesdaybook.automata.labeler.StateLabeler;

public final class Labeler {
    private Labeler() {
    }

    public static void labelStates(State state) {
        Labeler.labelStates(state, 0, "");
    }

    public static void labelStates(State state, String name) {
        Labeler.labelStates(state, 0, name);
    }

    public static void labelStates(State state, int count) {
        Labeler.labelStates(state, count, "");
    }

    public static void labelStates(State state, int count, String name) {
        StateCountLabeler labeler = new StateCountLabeler(count, name);
        Labeler.labelStates(state, labeler);
    }

    public static void labelStates(State state, StateLabeler labeler) {
        HashSet<State> visitedStates = new HashSet<State>();
        Labeler.labelAllStates(state, labeler, visitedStates);
    }

    private static void labelAllStates(State state, StateLabeler labeler, Set<State> visitedStates) {
        if (!visitedStates.contains(state)) {
            visitedStates.add(state);
            labeler.label(state);
            List<Transition> transitions = state.getTransitions();
            for (Transition transition : transitions) {
                Labeler.labelAllStates(transition.getToState(), labeler, visitedStates);
            }
        }
    }
}

