/*
 * Decompiled with CFR 0.152.
 */
package net.domesdaybook.automata.nfa;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.domesdaybook.automata.State;
import net.domesdaybook.automata.Transition;
import net.domesdaybook.automata.nfa.NfaState;
import net.domesdaybook.automata.nfa.NfaTransitions;
import net.domesdaybook.object.copy.DeepCopy;

public class NfaTransitionsSingle
implements NfaTransitions {
    private Transition transition;
    private Set<NfaState> stateSet;

    public NfaTransitionsSingle(Transition transition) {
        this.setTransition(transition);
    }

    public NfaTransitionsSingle(NfaTransitionsSingle other) {
        this.setTransition(other.transition);
    }

    @Override
    public void addTransition(Transition transition) {
        this.setTransition(transition);
    }

    @Override
    public final Set<NfaState> getStatesForByte(byte theByte) {
        State state = this.transition.getStateForByte(theByte);
        if (state != null) {
            return this.stateSet;
        }
        return NO_STATES;
    }

    @Override
    public final int size() {
        return 1;
    }

    @Override
    public List<Transition> getTransitions() {
        ArrayList<Transition> result = new ArrayList<Transition>();
        result.add(this.transition);
        return result;
    }

    private void setTransition(Transition transition) {
        this.transition = transition;
        this.stateSet = new HashSet<NfaState>();
        this.stateSet.add((NfaState)transition.getToState());
    }

    @Override
    public NfaTransitionsSingle deepCopy(Map<DeepCopy, DeepCopy> oldToNewObjects) {
        NfaTransitionsSingle copy = (NfaTransitionsSingle)oldToNewObjects.get(this);
        if (copy == null) {
            copy = new NfaTransitionsSingle(this);
            oldToNewObjects.put(this, copy);
            Transition transitionCopy = (Transition)this.transition.deepCopy(oldToNewObjects);
            copy.addTransition(transitionCopy);
        }
        return copy;
    }
}

