/*
 * Decompiled with CFR 0.152.
 */
package net.domesdaybook.matcher.sequence;

import net.domesdaybook.matcher.sequence.SequenceMatcher;
import net.domesdaybook.matcher.singlebyte.ByteMatcher;
import net.domesdaybook.matcher.singlebyte.CaseInsensitiveByteMatcher;
import net.domesdaybook.matcher.singlebyte.SingleByteMatcher;
import net.domesdaybook.reader.ByteReader;

public class CaseInsensitiveStringMatcher
implements SequenceMatcher {
    private final int length;
    private final String caseInsensitiveString;
    private final SingleByteMatcher[] charMatchList;

    public CaseInsensitiveStringMatcher(String caseInsensitiveASCIIString) {
        if (caseInsensitiveASCIIString == null || caseInsensitiveASCIIString.isEmpty()) {
            throw new IllegalArgumentException("Null or empty string passed in to CaseInsensitiveStringMatcher.");
        }
        this.caseInsensitiveString = caseInsensitiveASCIIString;
        this.length = caseInsensitiveASCIIString.length();
        this.charMatchList = new SingleByteMatcher[this.length];
        for (int charIndex = 0; charIndex < this.length; ++charIndex) {
            this.charMatchList[charIndex] = this.getByteMatcherForChar(caseInsensitiveASCIIString.charAt(charIndex));
        }
    }

    @Override
    public final int length() {
        return this.length;
    }

    @Override
    public final String toRegularExpression(boolean prettyPrint) {
        if (prettyPrint) {
            return " `" + this.caseInsensitiveString + "` ";
        }
        return "`" + this.caseInsensitiveString + "`";
    }

    @Override
    public final boolean matches(ByteReader reader, long matchFrom) {
        boolean result = true;
        SingleByteMatcher[] matchList = this.charMatchList;
        int localStop = this.length;
        for (int byteIndex = 0; result && byteIndex < localStop; ++byteIndex) {
            SingleByteMatcher charMatcher = matchList[byteIndex];
            byte theByte = reader.readByte(matchFrom + (long)byteIndex);
            result = charMatcher.matches(theByte);
        }
        return result;
    }

    @Override
    public final SingleByteMatcher getByteMatcherForPosition(int position) {
        return this.charMatchList[position];
    }

    private SingleByteMatcher getByteMatcherForChar(char theChar) {
        SingleByteMatcher result = theChar >= 'a' && theChar <= 'z' || theChar >= 'A' && theChar <= 'Z' ? new CaseInsensitiveByteMatcher(Character.valueOf(theChar)) : new ByteMatcher((byte)theChar);
        return result;
    }
}

