/*
 * Decompiled with CFR 0.152.
 */
package net.domesdaybook.matcher.sequence;

import net.domesdaybook.matcher.sequence.SequenceMatcher;
import net.domesdaybook.matcher.singlebyte.ByteMatcher;
import net.domesdaybook.matcher.singlebyte.SingleByteMatcher;
import net.domesdaybook.reader.ByteReader;

public class CaseSensitiveStringMatcher
implements SequenceMatcher {
    private final byte[] byteArray;
    private final String caseSensitiveString;
    private final int length;

    public CaseSensitiveStringMatcher(String caseSensitiveASCIIString) {
        if (caseSensitiveASCIIString == null || caseSensitiveASCIIString.isEmpty()) {
            throw new IllegalArgumentException("Null or empty string passed in to CaseSensitiveStringMatcher.");
        }
        this.caseSensitiveString = caseSensitiveASCIIString;
        int byteSequenceLength = caseSensitiveASCIIString.length();
        this.byteArray = new byte[byteSequenceLength];
        for (int byteIndex = 0; byteIndex < byteSequenceLength; ++byteIndex) {
            this.byteArray[byteIndex] = (byte)caseSensitiveASCIIString.charAt(byteIndex);
        }
        this.length = this.byteArray.length;
    }

    @Override
    public final boolean matches(ByteReader reader, long matchFrom) {
        boolean result = true;
        byte[] localArray = this.byteArray;
        int localStop = this.length;
        for (int byteIndex = 0; result && byteIndex < localStop; ++byteIndex) {
            result = localArray[byteIndex] == reader.readByte(matchFrom + (long)byteIndex);
        }
        return result;
    }

    @Override
    public final int length() {
        return this.length;
    }

    @Override
    public final String toRegularExpression(boolean prettyPrint) {
        if (prettyPrint) {
            return " '" + this.caseSensitiveString + "' ";
        }
        return "'" + this.caseSensitiveString + "'";
    }

    @Override
    public final SingleByteMatcher getByteMatcherForPosition(int position) {
        return new ByteMatcher(this.byteArray[position]);
    }
}

