/*
 * Decompiled with CFR 0.152.
 */
package net.domesdaybook.matcher.sequence;

import java.util.ArrayList;
import java.util.List;
import net.domesdaybook.matcher.sequence.SequenceMatcher;
import net.domesdaybook.matcher.singlebyte.SingleByteMatcher;
import net.domesdaybook.reader.ByteReader;

public class SingleByteSequenceMatcher
implements SequenceMatcher {
    private final List<SingleByteMatcher> matcherSequence = new ArrayList<SingleByteMatcher>();
    private final int length;

    public SingleByteSequenceMatcher(List<SingleByteMatcher> sequence) {
        if (sequence == null || sequence.isEmpty()) {
            throw new IllegalArgumentException("Null or empty sequence passed in to SingleByteSequenceMatcher.");
        }
        this.matcherSequence.addAll(sequence);
        this.length = this.matcherSequence.size();
    }

    public SingleByteSequenceMatcher(SingleByteMatcher matcher) {
        if (matcher == null) {
            throw new IllegalArgumentException("Null matcher passed in to SingleByteSequenceMatcher.");
        }
        this.matcherSequence.add(matcher);
        this.length = 1;
    }

    @Override
    public final boolean matches(ByteReader reader, long matchFrom) {
        boolean result = true;
        List<SingleByteMatcher> matchList = this.matcherSequence;
        int localStop = this.length;
        for (int byteIndex = 0; result && byteIndex < localStop; ++byteIndex) {
            SingleByteMatcher byteMatcher = matchList.get(byteIndex);
            byte byteRead = reader.readByte(matchFrom + (long)byteIndex);
            result = byteMatcher.matches(byteRead);
        }
        return result;
    }

    @Override
    public final SingleByteMatcher getByteMatcherForPosition(int position) {
        return this.matcherSequence.get(position);
    }

    @Override
    public final int length() {
        return this.length;
    }

    @Override
    public final String toRegularExpression(boolean prettyPrint) {
        StringBuilder builder = new StringBuilder();
        for (SingleByteMatcher matcher : this.matcherSequence) {
            builder.append(matcher.toRegularExpression(prettyPrint));
        }
        return builder.toString();
    }
}

