/*
 * Decompiled with CFR 0.152.
 */
package net.domesdaybook.matcher.singlebyte;

import java.util.ArrayList;
import java.util.List;

public class ByteUtilities {
    private static final int QUOTE_CHARACTER_VALUE = 39;
    private static final int START_PRINTABLE_ASCII = 32;
    private static final int END_PRINTABLE_ASCII = 126;
    private static int[] MASK = new int[]{85, 51, 15};

    private ByteUtilities() {
    }

    public static int countSetBits(byte b) {
        byte bits = b;
        int result = bits - (bits >>> 1 & MASK[0]);
        result = (result >>> 2 & MASK[1]) + (result & MASK[1]);
        result = (result >>> 4) + result & MASK[2];
        return result;
    }

    public static int countUnsetBits(byte b) {
        return 8 - ByteUtilities.countSetBits(b);
    }

    public static int countBytesMatchingAllBits(byte bitmask) {
        return 1 << ByteUtilities.countUnsetBits(bitmask);
    }

    public static int countBytesMatchingAnyBit(byte bitmask) {
        return 256 - ByteUtilities.countBytesMatchingAllBits(bitmask);
    }

    public static List<Byte> getBytesMatchingAllBitMask(byte bitMask) {
        ArrayList<Byte> bytes = new ArrayList<Byte>();
        for (int byteIndex = 0; byteIndex < 256; ++byteIndex) {
            byte byteValue = (byte)byteIndex;
            if ((byteValue & bitMask) != bitMask) continue;
            bytes.add((byte)byteIndex);
        }
        return bytes;
    }

    public static List<Byte> getBytesMatchingAnyBitMask(byte bitMask) {
        ArrayList<Byte> bytes = new ArrayList<Byte>();
        for (int byteIndex = 1; byteIndex < 256; ++byteIndex) {
            byte byteValue = (byte)byteIndex;
            if ((byteValue & bitMask) <= 0) continue;
            bytes.add((byte)byteIndex);
        }
        return bytes;
    }

    public static String byteToString(boolean prettyPrint, int byteValue) {
        String result = null;
        result = prettyPrint ? (byteValue >= 32 && byteValue <= 126 && byteValue != 39 ? String.format(" '%c' ", byteValue) : String.format(" %02x ", byteValue)) : String.format("%02x", byteValue);
        return result;
    }
}

