/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.util;

import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Defs {
    private static final Logger logger = Logger.getLogger(Defs.class.toString());

    public static String property(String name) {
        return Defs.property(name, null);
    }

    public static String property(String name, String defaultValue) {
        try {
            return System.getProperty(name, defaultValue);
        }
        catch (SecurityException ex) {
            logger.log(Level.FINE, "Security exception, property could not be set.", ex);
            return defaultValue;
        }
    }

    public static int intProperty(String name, int defaultValue) {
        String value = Defs.property(name);
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException ex) {
                logger.log(Level.FINE, "Failed to parse property.", ex);
            }
        }
        return defaultValue;
    }

    public static boolean booleanProperty(String name) {
        return Defs.booleanProperty(name, false);
    }

    public static boolean booleanProperty(String name, boolean defaultValue) {
        String value = Defs.property(name);
        if (value != null) {
            switch (value.length()) {
                case 2: {
                    if (!"no".equals(value.toLowerCase())) break;
                    return false;
                }
                case 3: {
                    if (!"yes".equals(value.toLowerCase())) break;
                    return true;
                }
                case 4: {
                    if (!"true".equals(value.toLowerCase())) break;
                    return true;
                }
                case 5: {
                    if (!"false".equals(value.toLowerCase())) break;
                    return false;
                }
            }
        }
        return defaultValue;
    }

    public static String sysProperty(String name) {
        return Defs.property(name);
    }

    public static String sysProperty(String name, String defaultValue) {
        return Defs.property(name, defaultValue);
    }

    public static int sysPropertyInt(String name, int defaultValue) {
        return Defs.intProperty(name, defaultValue);
    }

    public static boolean sysPropertyBoolean(String name) {
        return Defs.booleanProperty(name);
    }

    public static boolean sysPropertyBoolean(String name, boolean defaultValue) {
        return Defs.booleanProperty(name, defaultValue);
    }

    public static void setProperty(String property, Object value) {
        try {
            Properties prop = System.getProperties();
            if (value != null) {
                prop.put(property, value);
            }
        }
        catch (SecurityException ex) {
            logger.log(Level.FINE, "Security exception, property could not be set.", ex);
        }
    }

    public static void setSystemProperty(String name, String value) {
        Defs.setProperty(name, value);
    }
}

