/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module;

import edu.harvard.hul.ois.jhove.Agent;
import edu.harvard.hul.ois.jhove.AgentType;
import edu.harvard.hul.ois.jhove.Checksummer;
import edu.harvard.hul.ois.jhove.Document;
import edu.harvard.hul.ois.jhove.DocumentType;
import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.ExternalSignature;
import edu.harvard.hul.ois.jhove.Identifier;
import edu.harvard.hul.ois.jhove.IdentifierType;
import edu.harvard.hul.ois.jhove.InfoMessage;
import edu.harvard.hul.ois.jhove.InternalSignature;
import edu.harvard.hul.ois.jhove.Message;
import edu.harvard.hul.ois.jhove.Module;
import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.NisoImageMetadata;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.SignatureType;
import edu.harvard.hul.ois.jhove.SignatureUseType;
import edu.harvard.hul.ois.jhove.module.tiff.ExifIFD;
import edu.harvard.hul.ois.jhove.module.tiff.GPSInfoIFD;
import edu.harvard.hul.ois.jhove.module.tiff.GlobalParametersIFD;
import edu.harvard.hul.ois.jhove.module.tiff.IFD;
import edu.harvard.hul.ois.jhove.module.tiff.InteroperabilityIFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffException;
import edu.harvard.hul.ois.jhove.module.tiff.TiffIFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfile;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfileClassB;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfileClassG;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfileClassITBL;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfileClassITBLP1;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfileClassITBP;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfileClassITBPP1;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfileClassITBPP2;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfileClassITCT;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfileClassITCTP1;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfileClassITCTP2;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfileClassITFP;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfileClassITFPP1;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfileClassITFPP2;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfileClassITHC;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfileClassITHCP1;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfileClassITHCP2;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfileClassITLW;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfileClassITLWP1;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfileClassITLWP2;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfileClassITMP;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfileClassITMPP1;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfileClassITMPP2;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfileClassITSD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfileClassITSDP2;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfileClassP;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfileClassR;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfileClassY;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfileDLFBW;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfileDLFColor;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfileDLFGray;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfileDNG;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfileDNGThumb;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfileEP;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfileExif;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfileExifThumb;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfileFXC;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfileFXF;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfileFXJ;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfileFXL;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfileFXM;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfileFXS;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfileGeoTIFF;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfileRFC1314;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class TiffModule
extends ModuleBase {
    private static final String NAME = "TIFF-hul";
    private static final String RELEASE = "1.5";
    private static final int[] DATE = new int[]{2007, 10, 2};
    private static final String[] FORMAT = new String[]{"TIFF", "Tagged Image File Format"};
    private static final String COVERAGE = "TIFF 4.0, 5.0, and 6.0; TIFF/IT (ISO/DIS 12639:2003), including file types CT, LW, HC, MP, BP, BL, and FP, and conformance levels P1 and P2; TIFF/EP (ISO 12234-2:2001); Exif 2.0, 2.1 (JEIDA-49-1998), and 2.2 (JEITA CP-3451); Baseline GeoTIFF 1.0; Baseline 6.0 bilevel (known in TIFF 5.0 as Class B), grayscale (Class G), palette-color (Class P), and RGB (Class R); 6.0 extension YCbCr (Class Y); DLF Benchmark for Faithful Digital Reproductions of Monographs and Serials; TIFF-FX (RFC 2301), Class F (RFC 2306); RFC 1314; and DNG (Digital Negative)";
    private static final String[] MIMETYPE = new String[]{"image/tiff", "image/tiff-fx", "image/ief"};
    private static final String WELLFORMED = "A TIFF file is well-formed if it has a big-endian or little-endian header; at least one IFD; all IFDs are 16-bit word aligned; all IFDs have at least one entry; all IFD entries are sorted in ascending order by tag number; all IFD entries specify the correct type and count; all value offsets are 16-bit word aligned; all value offsets reference locations within the file; and the final IFD is followed by an offset of 0";
    private static final String VALIDITY = "A TIFF file is valid if well-formed; ImageLength, ImageWidth, and PhotometricInterpretation tags are defined; strip or tile tags are defined; tag values are self-consistent (see JHOVE documentation); TileWidth and TileLength values are integral multiples of 16; and DateTime tag is properly formatted";
    private static final String REPINFO = "Additional representation information includes: NISO Z39.87 Digital Still Image Technical Metadata and all other tag values";
    private static final String NOTE = null;
    private static final String RIGHTS = "Copyright 2003-2007 by JSTOR and the President and Fellows of Harvard College. Released under the GNU Lesser General Public License.";
    protected List _profile;
    TiffProfileExif _exifMainProfile;
    TiffProfileExifThumb _exifThumbnailProfile;
    TiffProfileDNG _dngMainProfile;
    TiffProfileDNGThumb _dngThumbnailProfile;
    protected boolean _exifFirstFlag;
    protected boolean _exifThumbnailFlag;
    protected boolean _dngThumbnailFlag;
    protected boolean _dngRawFlag;
    protected RandomAccessFile _raf;
    protected int _version;
    protected boolean _byteOffsetIsValid;

    public TiffModule() {
        super(NAME, RELEASE, DATE, FORMAT, COVERAGE, MIMETYPE, WELLFORMED, VALIDITY, REPINFO, NOTE, RIGHTS, true);
        Agent agent;
        Agent agent2 = new Agent("Harvard University Library", AgentType.EDUCATIONAL);
        agent2.setAddress("Office for Information Systems, 90 Mt. Auburn St., Cambridge, MA 02138");
        agent2.setTelephone("+1 (617) 495-3724");
        agent2.setEmail("jhove-support@hulmail.harvard.edu");
        this._vendor = agent2;
        Document document = new Document("TIFF, Revision 6.0", DocumentType.REPORT);
        agent2 = agent = new Agent("Adobe Systems, Inc.", AgentType.COMMERCIAL);
        agent2.setAddress("345 Park Avenue, San Jose, California 95110-2704");
        agent2.setTelephone("+1 (408) 536-6000");
        agent2.setFax("+1 (408) 537-6000");
        agent2.setWeb("http://www.adobe.com/");
        document.setPublisher(agent2);
        document.setDate("1992-06-03");
        document.setEdition("Final");
        document.setIdentifier(new Identifier("http://partners.adobe.com/asn/tech/tiff/specification.jsp", IdentifierType.URL));
        this._specification.add(document);
        document = new Document("TIFF, Revision 5.0", DocumentType.REPORT);
        agent2 = new Agent("Aldus Corporation", AgentType.COMMERCIAL);
        document.setPublisher(agent2);
        document.setDate("1988-08-08");
        document.setNote("Aldus was acquired by Adobe Systems, Inc., in 1993");
        this._specification.add(document);
        document = new Document("Tagged Image File Format, Rev. 4.0", DocumentType.REPORT);
        agent2 = new Agent("Aldus Corporation", AgentType.COMMERCIAL);
        document.setPublisher(agent2);
        document.setDate("1987-04-30");
        document.setNote("Aldus was acquired by Adobe Systems, Inc., in 1993");
        this._specification.add(document);
        document = new Document("ISO 12234-2:2001, Electronic still-picture imaging -- Removable memory -- Part 2: TIFF/EP image data format", DocumentType.STANDARD);
        Agent agent3 = new Agent("ISO", AgentType.STANDARD);
        agent3.setAddress("1, rue de Varembe, Casa postale 56, CH-1211, Geneva 20, Switzerland");
        agent3.setTelephone("+41 22 749 01 11");
        agent3.setFax("+41 22 733 34 30");
        agent3.setEmail("iso@iso.ch");
        agent3.setWeb("http://www.iso.org");
        document.setPublisher(agent3);
        document.setDate("2001-10-15");
        Identifier identifier = new Identifier("ISO 12234-2:2001(E)", IdentifierType.ISO);
        document.setIdentifier(identifier);
        this._specification.add(document);
        document = new Document("ISO/DIS 12639:2003, Graphic technology -- Prepress digital data exchange -- Tag image file format for image technology (TIFF/IT)", DocumentType.STANDARD);
        document.setPublisher(agent3);
        document.setDate("2003-09-04");
        identifier = new Identifier("ISO/DIS 12639:2003(E)", IdentifierType.ISO);
        document.setIdentifier(identifier);
        this._specification.add(document);
        document = new Document("Benchmark for Faithful Digital Reproductions of Monographs and Serials", DocumentType.REPORT);
        agent2 = new Agent("Digital Library Federation", AgentType.NONPROFIT);
        agent2.setAddress("1755 Massachusetts Ave., NW, Suite 500, Washington, DC 20036");
        agent2.setTelephone("+1 (202) 939-4761");
        agent2.setFax("+1 (202) 939-4765");
        agent2.setEmail("dlf@clir.org");
        agent2.setWeb("http://www.diglib.org/");
        document.setPublisher(agent2);
        document.setEdition("Version 1");
        document.setDate("2002-12");
        identifier = new Identifier("http://www.diglib.org/standards/bmarkfin.htm", IdentifierType.URL);
        document.setIdentifier(identifier);
        this._specification.add(document);
        document = new Document("Adobe PageMaker TIFF 6.0 Technical Notes", DocumentType.REPORT);
        document.setPublisher(agent);
        document.setDate("1995-09-14");
        identifier = new Identifier("http://partners.adobe.com/asn/developer/pdfs/tn/TIFFPM6.pdf", IdentifierType.URL);
        document.setIdentifier(identifier);
        this._specification.add(document);
        document = new Document("Adobe Photoshop TIFF Technical Notes", DocumentType.REPORT);
        document.setPublisher(agent);
        document.setDate("2002-03-22");
        identifier = new Identifier("http://partners.adobe.com/asn/developer/pdfs/tn/TIFFphotoshop.pdf", IdentifierType.URL);
        document.setIdentifier(identifier);
        this._specification.add(document);
        document = new Document("Adobe Photoshop 6.0 File Formats Specification", DocumentType.REPORT);
        document.setPublisher(agent);
        document.setDate("2000-11");
        document.setEdition("Version 6.0, Release 2");
        this._specification.add(document);
        document = new Document("TIFF-F Revised Specification: The Spirit of TIFF Class F", DocumentType.REPORT);
        agent2 = new Agent("Cygnet Technologies", AgentType.COMMERCIAL);
        document.setPublisher(agent2);
        document.setDate("1990-04-28");
        document.setNote("Cygnet is no longer in business");
        identifier = new Identifier("http://hul.harvard.edu/jhove/references.html#classf", IdentifierType.URL);
        document.setIdentifier(identifier);
        this._specification.add(document);
        document = new Document("Tag Image File Format (TIFF) -- F Profile for Facsimile", DocumentType.RFC);
        Agent agent4 = new Agent("IETF", AgentType.STANDARD);
        agent4.setWeb("http://www.ietf.org");
        document.setPublisher(agent4);
        document.setDate("1998-03");
        identifier = new Identifier("RFC 2306", IdentifierType.RFC);
        document.setIdentifier(identifier);
        identifier = new Identifier("http://hul.harvard.edu/jhove/references.html#rfc2306", IdentifierType.URL);
        document.setIdentifier(identifier);
        this._specification.add(document);
        document = new Document("A File Format for the Exchange of Images in the Internet", DocumentType.RFC);
        document.setPublisher(agent4);
        document.setDate("1992-04");
        identifier = new Identifier("RFC 1314", IdentifierType.RFC);
        document.setIdentifier(identifier);
        identifier = new Identifier("http://www.ietf.org/rfc/rfc1314.txt", IdentifierType.URL);
        document.setIdentifier(identifier);
        this._specification.add(document);
        document = new Document("Exchangeable image file format for digital still cameras: Exif Version 2.2", DocumentType.STANDARD);
        Agent agent5 = new Agent("Japan Electronics and Information Technology Industries Association", AgentType.STANDARD);
        agent5.setWeb("http://www.jeita.or.jp/");
        agent5.setAddress("Mitsui Sumitomo Kaijo Building Annex, 11, Kanda Surugadai 3-chome, Chiyoda-ku, Tokyo 101-0062, Japan");
        agent5.setTelephone("+81(03) 3518-6421");
        agent5.setFax("+81(03) 3295-8721");
        document.setPublisher(agent5);
        document.setDate("2002-04");
        identifier = new Identifier("JEITA CP-3451", IdentifierType.JEITA);
        document.setIdentifier(identifier);
        identifier = new Identifier("http://www.exif.org/Exif2-2.PDF", IdentifierType.URL);
        document.setIdentifier(identifier);
        this._specification.add(document);
        document = new Document("Digital Still Camera Image File Format Standard (Exchangeable image file format for Digital Still Camera:Exif)", DocumentType.STANDARD);
        document.setPublisher(agent5);
        document.setDate("1998-12");
        identifier = new Identifier("JEITA JEIDA-49-1998", IdentifierType.JEITA);
        document.setIdentifier(identifier);
        identifier = new Identifier("http://www.exif.org/dcf-exif.PDF", IdentifierType.URL);
        document.setIdentifier(identifier);
        this._specification.add(document);
        document = new Document("GeoTIFF Format Specification: GeoTIFF Revision 1.0", DocumentType.REPORT);
        agent2 = new Agent("Niles Ritter", AgentType.OTHER);
        document.setAuthor(agent2);
        agent2 = new Agent("Mike Ruth", AgentType.OTHER);
        document.setAuthor(agent2);
        agent2 = new Agent("GeoTIFF Working Group", AgentType.OTHER);
        document.setPublisher(agent2);
        document.setEdition("Version 1.8.1");
        document.setDate("1995-10-31");
        identifier = new Identifier("http://remotesensing.org/geotiff/spec/geotiffhome.html", IdentifierType.URL);
        document.setIdentifier(identifier);
        this._specification.add(document);
        document = new Document("File Format for Internet Fax", DocumentType.RFC);
        document.setPublisher(agent4);
        document.setDate("1998-03");
        identifier = new Identifier("RFC 2301", IdentifierType.RFC);
        document.setIdentifier(identifier);
        identifier = new Identifier("http://www.ietf.org/rfc/rfc2301.txt", IdentifierType.URL);
        document.setIdentifier(identifier);
        this._specification.add(document);
        int[] nArray = new int[]{73, 73, 42, 0};
        InternalSignature internalSignature = new InternalSignature(nArray, SignatureType.MAGIC, SignatureUseType.MANDATORY_IF_APPLICABLE, 0, "Little-endian (least significant byte first)");
        this._signature.add(internalSignature);
        int[] nArray2 = new int[]{77, 77, 0, 42};
        internalSignature = new InternalSignature(nArray2, SignatureType.MAGIC, SignatureUseType.MANDATORY_IF_APPLICABLE, 0, "Big-endian (most significant byte first)");
        this._signature.add(internalSignature);
        internalSignature = new ExternalSignature("TIFF", SignatureType.FILETYPE, SignatureUseType.OPTIONAL);
        this._signature.add(internalSignature);
        internalSignature = new ExternalSignature(".tif", SignatureType.EXTENSION, SignatureUseType.OPTIONAL);
        this._signature.add(internalSignature);
        internalSignature = new ExternalSignature(".tfx", SignatureType.EXTENSION, SignatureUseType.OPTIONAL, "For TIFF-FX");
        this._signature.add(internalSignature);
        internalSignature = new ExternalSignature("TFX ", SignatureType.FILETYPE, SignatureUseType.OPTIONAL, "For TIFF-FX");
        this._signature.add(internalSignature);
        this.buildProfileList();
        this._byteOffsetIsValid = false;
    }

    public final void parse(RandomAccessFile randomAccessFile, RepInfo repInfo) throws IOException {
        Object object2;
        if (this._defaultParams != null) {
            for (Object object2 : this._defaultParams) {
                if (!((String)object2).toLowerCase().equals("byteoffset=true")) continue;
                this._byteOffsetIsValid = true;
            }
        }
        this._raf = randomAccessFile;
        this.initParse();
        repInfo.setModule((Module)this);
        repInfo.setMimeType(this._mimeType[0]);
        repInfo.setFormat(this._format[0]);
        Property[] propertyArray = new Property[2];
        object2 = null;
        boolean bl = true;
        try {
            randomAccessFile.seek(0L);
            byte by = this._raf.readByte();
            byte by2 = this._raf.readByte();
            if (by != by2 || by != 73 && by != 77) {
                throw new TiffException("No TIFF header: " + (char)by + (char)by2, 0L);
            }
            bl = false;
            this._bigEndian = by == 77;
            propertyArray[0] = new Property("ByteOrder", PropertyType.STRING, (Object)(this._bigEndian ? "big-endian" : "little-endian"));
            int n = TiffModule.readUnsignedShort((RandomAccessFile)this._raf, (boolean)this._bigEndian);
            if (n != 42) {
                throw new TiffException("No TIFF magic number: " + n, 2L);
            }
            repInfo.setSigMatch(this._name);
            this._version = 4;
            object2 = this.parseIFDs(4L, repInfo);
            repInfo.setVersion(Integer.toString(this._version) + ".0");
            LinkedList<Property> linkedList = new LinkedList<Property>();
            Property property = new Property("IFDs", PropertyType.PROPERTY, PropertyArity.LIST, linkedList);
            linkedList.add(new Property("Number", PropertyType.INTEGER, (Object)new Integer(object2.size())));
            ListIterator listIterator = object2.listIterator();
            while (listIterator.hasNext()) {
                ListIterator listIterator2;
                IFD iFD = (IFD)listIterator.next();
                linkedList.add(iFD.getProperty(this._je != null ? this._je.getShowRawFlag() : false));
                List list = iFD.getErrors();
                if (!list.isEmpty()) {
                    repInfo.setValid(false);
                    listIterator2 = list.listIterator();
                    while (listIterator2.hasNext()) {
                        repInfo.setMessage((Message)new ErrorMessage((String)listIterator2.next()));
                    }
                }
                listIterator2 = this._profile.listIterator();
                while (listIterator2.hasNext()) {
                    TiffProfile tiffProfile = (TiffProfile)listIterator2.next();
                    if (tiffProfile.isAlreadyOK() || !tiffProfile.satisfiesProfile(iFD)) continue;
                    repInfo.setProfile(tiffProfile.getText());
                }
                if (iFD.isFirst()) {
                    this._exifFirstFlag = this._exifMainProfile.satisfiesProfile(iFD);
                    this._exifThumbnailProfile.setMainCompression(((TiffIFD)iFD).getNisoImageMetadata().getCompressionScheme());
                } else if (iFD.isThumbnail()) {
                    this._exifThumbnailFlag = this._exifThumbnailProfile.satisfiesProfile(iFD);
                }
                if (iFD.isFirst()) {
                    this._dngThumbnailFlag = this._dngThumbnailProfile.satisfiesProfile(iFD);
                }
                if (this._dngRawFlag) continue;
                this._dngRawFlag = this._dngMainProfile.satisfiesProfile(iFD);
            }
            propertyArray[1] = property;
            if (this._exifFirstFlag && this._exifThumbnailFlag) {
                repInfo.setProfile(this._exifMainProfile.getText());
            }
            if (this._dngThumbnailFlag && this._dngRawFlag) {
                repInfo.setProfile(this._dngMainProfile.getText());
            }
            repInfo.setProperty(new Property("TIFFMetadata", PropertyType.PROPERTY, PropertyArity.ARRAY, (Object)propertyArray));
        }
        catch (TiffException tiffException) {
            repInfo.setMessage((Message)new ErrorMessage(tiffException.getMessage(), tiffException.getOffset()));
            repInfo.setWellFormed(false);
            return;
        }
        catch (IOException iOException) {
            String string = bl ? "File is too short" : iOException.getClass().getName();
            repInfo.setMessage((Message)new ErrorMessage(string));
            repInfo.setWellFormed(false);
            return;
        }
        if (this._je != null && this._je.getChecksumFlag() && repInfo.getChecksum().size() == 0) {
            Checksummer checksummer = new Checksummer();
            this.calcRAChecksum(checksummer, randomAccessFile);
            this.setChecksums(checksummer, repInfo);
        }
        repInfo.setMimeType(this._mimeType[this.selectMimeTypeIndex()]);
        this.checkValidity((List)object2, repInfo);
    }

    public final List exifParse(RandomAccessFile randomAccessFile, RepInfo repInfo) throws IOException {
        this._raf = randomAccessFile;
        this.initParse();
        List list = null;
        boolean bl = true;
        try {
            randomAccessFile.seek(0L);
            byte by = this._raf.readByte();
            byte by2 = this._raf.readByte();
            if (by != by2 || by != 73 && by != 77) {
                throw new TiffException("No TIFF header: " + (char)by + (char)by2, 0L);
            }
            this._bigEndian = by == 77;
            int n = TiffModule.readUnsignedShort((RandomAccessFile)this._raf, (boolean)this._bigEndian);
            if (n != 42) {
                throw new TiffException("No TIFF magic number: " + n, 2L);
            }
            bl = false;
            this._version = 4;
            list = this.parseIFDs(4L, repInfo, true);
            ListIterator listIterator = list.listIterator();
            while (listIterator.hasNext()) {
                IFD iFD = (IFD)listIterator.next();
                List list2 = iFD.getErrors();
                if (list2.isEmpty()) continue;
                repInfo.setValid(false);
                ListIterator listIterator2 = list2.listIterator();
                while (listIterator2.hasNext()) {
                    repInfo.setMessage((Message)new ErrorMessage((String)listIterator2.next()));
                }
            }
        }
        catch (TiffException tiffException) {
            repInfo.setMessage((Message)new InfoMessage(tiffException.getMessage(), tiffException.getOffset()));
            return list;
        }
        catch (IOException iOException) {
            String string = bl ? "Embedded Exif block is too short" : iOException.getClass().getName();
            repInfo.setMessage((Message)new ErrorMessage(string));
            repInfo.setWellFormed(false);
            return null;
        }
        return list;
    }

    protected void buildProfileList() {
        this._profile = new ArrayList(30);
        this._profile.add(new TiffProfileClassB());
        this._profile.add(new TiffProfileClassG());
        this._profile.add(new TiffProfileClassP());
        this._profile.add(new TiffProfileClassR());
        this._profile.add(new TiffProfileClassY());
        this._profile.add(new TiffProfileClassITBL());
        this._profile.add(new TiffProfileClassITBLP1());
        this._profile.add(new TiffProfileClassITBP());
        this._profile.add(new TiffProfileClassITBPP1());
        this._profile.add(new TiffProfileClassITBPP2());
        this._profile.add(new TiffProfileClassITCT());
        this._profile.add(new TiffProfileClassITCTP1());
        this._profile.add(new TiffProfileClassITCTP2());
        this._profile.add(new TiffProfileClassITFP());
        this._profile.add(new TiffProfileClassITFPP1());
        this._profile.add(new TiffProfileClassITFPP2());
        this._profile.add(new TiffProfileClassITHC());
        this._profile.add(new TiffProfileClassITHCP1());
        this._profile.add(new TiffProfileClassITHCP2());
        this._profile.add(new TiffProfileClassITLW());
        this._profile.add(new TiffProfileClassITLWP1());
        this._profile.add(new TiffProfileClassITLWP2());
        this._profile.add(new TiffProfileClassITMP());
        this._profile.add(new TiffProfileClassITMPP1());
        this._profile.add(new TiffProfileClassITMPP2());
        this._profile.add(new TiffProfileClassITSD());
        this._profile.add(new TiffProfileClassITSDP2());
        this._profile.add(new TiffProfileEP());
        this._profile.add(new TiffProfileGeoTIFF());
        this._profile.add(new TiffProfileDLFBW());
        this._profile.add(new TiffProfileDLFGray());
        this._profile.add(new TiffProfileDLFColor());
        this._profile.add(new TiffProfileRFC1314());
        this._profile.add(new TiffProfileFXS());
        this._profile.add(new TiffProfileFXF());
        this._profile.add(new TiffProfileFXJ());
        this._profile.add(new TiffProfileFXL());
        this._profile.add(new TiffProfileFXC());
        this._profile.add(new TiffProfileFXM());
        this._exifMainProfile = new TiffProfileExif();
        this._exifThumbnailProfile = new TiffProfileExifThumb();
        this._dngMainProfile = new TiffProfileDNG();
        this._dngThumbnailProfile = new TiffProfileDNGThumb();
    }

    protected void checkValidity(List list, RepInfo repInfo) {
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            try {
                IFD iFD = (IFD)listIterator.next();
                if (!(iFD instanceof TiffIFD)) continue;
                this.checkValidity((TiffIFD)iFD, repInfo);
            }
            catch (TiffException tiffException) {
                repInfo.setMessage((Message)new ErrorMessage(tiffException.getMessage(), tiffException.getOffset()));
                repInfo.setValid(false);
            }
        }
    }

    protected void checkValidity(TiffIFD tiffIFD, RepInfo repInfo) throws TiffException {
        String string;
        int[] nArray;
        int n;
        boolean bl;
        long l;
        long l2;
        NisoImageMetadata nisoImageMetadata = tiffIFD.getNisoImageMetadata();
        int n2 = nisoImageMetadata.getColorSpace();
        if (n2 == -1) {
            this.reportInvalid("PhotometricInterpretation not defined", repInfo);
        }
        if ((l2 = nisoImageMetadata.getImageWidth()) == -1L) {
            this.reportInvalid("ImageWidth not defined", repInfo);
        }
        if ((l = nisoImageMetadata.getImageLength()) == -1L) {
            this.reportInvalid("ImageLength not defined", repInfo);
        }
        long[] lArray = nisoImageMetadata.getStripOffsets();
        long[] lArray2 = nisoImageMetadata.getStripByteCounts();
        boolean bl2 = lArray != null || lArray2 != null;
        long l3 = nisoImageMetadata.getTileWidth();
        long l4 = nisoImageMetadata.getTileLength();
        long[] lArray3 = nisoImageMetadata.getTileOffsets();
        long[] lArray4 = nisoImageMetadata.getTileByteCounts();
        boolean bl3 = bl = l3 != -1L || l4 != -1L || lArray3 != null || lArray4 != null;
        if (bl2 && bl) {
            this.reportInvalid("Strips and tiles defined together", repInfo);
        }
        if (!bl2 && !bl) {
            this.reportInvalid("Neither strips nor tiles defined", repInfo);
        }
        int n3 = nisoImageMetadata.getPlanarConfiguration();
        int n4 = nisoImageMetadata.getSamplesPerPixel();
        if (bl2) {
            int n5;
            if (lArray == null) {
                this.reportInvalid("StripOffsets not defined", repInfo);
            }
            if (lArray2 == null) {
                this.reportInvalid("StripByteCounts not defined", repInfo);
            }
            if ((n5 = lArray.length) != lArray2.length) {
                this.reportInvalid("StripOffsets inconsistent with StripByteCounts: " + n5 + "!=" + lArray2.length, repInfo);
            }
            try {
                long l5 = this._raf.length();
                for (n = 0; n < n5; ++n) {
                    long l6 = lArray[n];
                    long l7 = lArray2[n];
                    if (l6 + l7 <= l5) continue;
                    this.reportInvalid("Invalid strip offset", repInfo);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (bl) {
            if (l3 == -1L) {
                this.reportInvalid("TileWidth not defined", repInfo);
            }
            if (l4 == -1L) {
                this.reportInvalid("TileLength not defined", repInfo);
            }
            if (lArray3 == null) {
                this.reportInvalid("TileOffsets not defined", repInfo);
            }
            if (lArray4 == null) {
                this.reportInvalid("TileByteCounts not defined", repInfo);
            }
            if (l3 % 16L > 0L) {
                this.reportInvalid("TileWidth not a multiple of 16: " + l3, repInfo);
            }
            if (l4 % 16L > 0L) {
                this.reportInvalid("TileLength not a multiple of 16: " + l4, repInfo);
            }
            long l8 = (l2 + l3 - 1L) / l3 * ((l + l4 - 1L) / l4);
            if (n3 == 2) {
                long l9 = (long)n4 * l8;
                if (lArray3 != null && (long)lArray3.length < l9) {
                    this.reportInvalid("Insufficient values for TileOffsets: " + lArray3.length + "<" + l9, repInfo);
                }
                if (lArray4 != null && (long)lArray4.length < l9) {
                    this.reportInvalid("Insufficient values for TileByteCountts: " + lArray4.length + "<" + l9, repInfo);
                }
            } else {
                if (lArray3 != null && (long)lArray3.length < l8) {
                    this.reportInvalid("Insufficient values for TileOffsets: " + lArray3.length + "<" + l8, repInfo);
                }
                if (lArray4 != null && (long)lArray4.length < l8) {
                    this.reportInvalid("Insufficient values for TileByteCounts: " + lArray4.length + "<" + l8, repInfo);
                }
            }
        }
        int n6 = (int)tiffIFD.getNewSubfileType();
        if (n2 == 4 && (n6 & 4) == 0 || n2 != 4 && (n6 & 4) != 0) {
            this.reportInvalid("PhotometricInterpretation and NewSubfileType must agree on transparency mask", repInfo);
        }
        int[] nArray2 = nisoImageMetadata.getBitsPerSample();
        if (n2 == 4 && (n4 < 1 || nArray2[0] != 1)) {
            this.reportInvalid("For transparency mask BitsPerSample must be 1", repInfo);
        }
        if ((n2 == 0 || n2 == 1 || n2 == 3 || n2 == 4) && n4 < 1) {
            this.reportInvalid("For PhotometricInterpretation, SamplesPerPixel must be >= 1, equals" + n4, repInfo);
        }
        if ((n2 == 2 || n2 == 6 || n2 == 8) && n4 < 3) {
            this.reportInvalid("For PhotometricInterpretation, SamplesPerPixel must be >= 3, equals" + n4, repInfo);
        }
        if (n2 == 3) {
            int n7;
            int[] nArray3 = nisoImageMetadata.getColormapBitCodeValue();
            int[] nArray4 = nisoImageMetadata.getColormapRedValue();
            int[] nArray5 = nisoImageMetadata.getColormapGreenValue();
            int[] nArray6 = nisoImageMetadata.getColormapBlueValue();
            if (nArray3 == null || nArray4 == null || nArray5 == null || nArray6 == null) {
                this.reportInvalid("ColorMap not defined for palette-color", repInfo);
            }
            if (n4 != 1) {
                this.reportInvalid("For palette-color SamplesPerPixel must be 1: " + n4, repInfo);
            }
            if (nArray3.length < (n7 = 1 << nArray2[0])) {
                this.reportInvalid("Insufficient ColorMap values for palette-color: " + nArray3.length + "<" + n7, repInfo);
            }
        }
        if (tiffIFD.getCellLength() != -1 && tiffIFD.getThreshholding() != 2) {
            this.reportInvalid("CellLength tag not permitted when Threshholding not 2", repInfo);
        }
        if ((nArray = tiffIFD.getDotRange()) != null && nArray2 != null) {
            n = 1 << nArray2[0];
            if (nArray.length < 2 || nArray[0] >= n || nArray[1] >= n) {
                this.reportInvalid("DotRange out of range specified by BitsPerSample", repInfo);
            }
        }
        if (nisoImageMetadata.getCompressionScheme() == 6 && tiffIFD.getJPEGProc() == -1) {
            this.reportInvalid("JPEGProc not defined for JPEG compression", repInfo);
        }
        if (n2 == 8 || n2 == 9) {
            int n8;
            n = 0;
            int[] nArray7 = nisoImageMetadata.getExtraSamples();
            if (nArray7 != null) {
                n = nisoImageMetadata.getExtraSamples().length;
            }
            if ((n8 = n4 - n) != 1 && n8 != 3) {
                this.reportInvalid("SamplesPerPixel-ExtraSamples not 1 or 3: " + n4 + "-" + n, repInfo);
            }
            for (int i = 0; i < nArray2.length; ++i) {
                if (nArray2[i] == 8 || nArray2[i] == 16) continue;
                this.reportInvalid("BitsPerSample not 8 or 16 for CIE L*a*b*", repInfo);
            }
        }
        if (tiffIFD.getClipPath() != null && tiffIFD.getXClipPathUnits() == -1L) {
            this.reportInvalid("XClipPathUnits not defined for ClipPath", repInfo);
        }
        if ((string = tiffIFD.getDateTime()) != null) {
            if (string.length() != 19) {
                this.reportInvalid("Invalid DateTime length: " + string, repInfo);
            }
            if (string.charAt(4) != ':' || string.charAt(7) != ':' || string.charAt(10) != ' ' || string.charAt(13) != ':' || string.charAt(16) != ':') {
                this.reportInvalid("Invalid DateTime separator: " + string, repInfo);
            }
            try {
                int n9 = Integer.parseInt(string.substring(0, 4));
                int n10 = Integer.parseInt(string.substring(5, 7));
                int n11 = Integer.parseInt(string.substring(8, 10));
                int n12 = Integer.parseInt(string.substring(11, 13));
                int n13 = Integer.parseInt(string.substring(14, 16));
                int n14 = Integer.parseInt(string.substring(17));
                if (n9 < 0 || n9 > 9999 || n10 < 1 || n10 > 12 || n11 < 1 || n11 > 31 || n12 < 0 || n12 > 24 || n13 < 0 || n13 > 59 || n14 < 0 || n13 > 59) {
                    this.reportInvalid("Invalid DateTime digit: " + string, repInfo);
                }
            }
            catch (Exception exception) {
                this.reportInvalid("Invalid DateTime digit: " + string, repInfo);
            }
        }
    }

    protected void reportInvalid(String string, RepInfo repInfo) {
        repInfo.setMessage((Message)new ErrorMessage(string));
        repInfo.setValid(false);
    }

    protected List parseIFDs(long l, RepInfo repInfo) throws TiffException {
        return this.parseIFDs(l, repInfo, false);
    }

    protected List parseIFDs(long l, RepInfo repInfo, boolean bl) throws TiffException {
        long l2 = 0L;
        try {
            this._raf.seek(l);
            l2 = TiffModule.readUnsignedInt((RandomAccessFile)this._raf, (boolean)this._bigEndian);
        }
        catch (IOException iOException) {
            throw new TiffException("Premature EOF", l);
        }
        if (l2 == 0L) {
            throw new TiffException("No IFD in file", l);
        }
        LinkedList linkedList = new LinkedList();
        while (l2 != 0L) {
            if ((l2 & 1L) != 0L) {
                throw new TiffException("IFD offset not word-aligned: " + l2);
            }
            IFD iFD = this.parseIFDChain(l2, repInfo, 0, linkedList, bl);
            l2 = iFD.getNext();
        }
        return linkedList;
    }

    protected IFD parseIFDChain(long l, RepInfo repInfo, int n, List list, boolean bl) throws TiffException {
        IFD iFD = null;
        switch (n) {
            case 1: {
                iFD = new ExifIFD(l, repInfo, this._raf, this._bigEndian);
                break;
            }
            case 2: {
                iFD = new InteroperabilityIFD(l, repInfo, this._raf, this._bigEndian);
                break;
            }
            case 3: {
                iFD = new GPSInfoIFD(l, repInfo, this._raf, this._bigEndian);
                break;
            }
            case 4: {
                iFD = new GlobalParametersIFD(l, repInfo, this._raf, this._bigEndian);
                break;
            }
            default: {
                iFD = new TiffIFD(l, repInfo, this._raf, this._bigEndian);
            }
        }
        iFD.parse(this._byteOffsetIsValid, bl);
        int n2 = iFD.getVersion();
        if (n2 > this._version) {
            this._version = n2;
        }
        if (list.size() == 0 && n == 0) {
            iFD.setFirst(true);
        } else if (list.size() == 1 && n == 0) {
            iFD.setThumbnail(true);
        }
        list.add(iFD);
        if (iFD instanceof TiffIFD) {
            IFD iFD2;
            long l2;
            TiffIFD tiffIFD = (TiffIFD)iFD;
            long[] lArray = tiffIFD.getSubIFDs();
            if (lArray != null) {
                for (int i = 0; i < lArray.length; ++i) {
                    l = lArray[i];
                    while (l != 0L) {
                        IFD iFD3 = this.parseIFDChain(l, repInfo, 0, list, bl);
                        l = iFD3.getNext();
                    }
                }
            }
            if ((l2 = tiffIFD.getExifIFD()) != -1L) {
                iFD2 = this.parseIFDChain(l2, repInfo, 1, list, bl);
                tiffIFD.setTheExifIFD((ExifIFD)iFD2);
            }
            if ((l2 = tiffIFD.getGPSInfoIFD()) != -1L) {
                iFD2 = this.parseIFDChain(l2, repInfo, 3, list, bl);
                tiffIFD.setTheGPSInfoIFD((GPSInfoIFD)iFD2);
            }
            if ((l2 = tiffIFD.getInteroperabilityIFD()) != -1L) {
                iFD2 = this.parseIFDChain(l2, repInfo, 2, list, bl);
                tiffIFD.setTheInteroperabilityIFD((InteroperabilityIFD)iFD2);
            }
            if ((l2 = tiffIFD.getGlobalParametersIFD()) != -1L) {
                iFD2 = this.parseIFDChain(l2, repInfo, 4, list, bl);
                tiffIFD.setTheGlobalParametersIFD((GlobalParametersIFD)iFD2);
            }
        }
        return iFD;
    }

    protected void initParse() {
        super.initParse();
        ListIterator listIterator = this._profile.listIterator();
        while (listIterator.hasNext()) {
            TiffProfile tiffProfile = (TiffProfile)listIterator.next();
            tiffProfile.setAlreadyOK(false);
        }
        this._exifFirstFlag = false;
        this._exifThumbnailFlag = true;
        this._dngThumbnailFlag = false;
        this._dngRawFlag = false;
    }

    protected int selectMimeTypeIndex() {
        int n = -1;
        ListIterator listIterator = this._profile.listIterator();
        while (listIterator.hasNext()) {
            TiffProfile tiffProfile = (TiffProfile)listIterator.next();
            if (!tiffProfile.isAlreadyOK()) continue;
            int n2 = tiffProfile.getMimeClass();
            if (n2 == 0) {
                return 0;
            }
            if (n >= 0 && n2 != n) {
                return 0;
            }
            n = n2;
        }
        if (n == -1) {
            return 0;
        }
        return n;
    }
}

