/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.aiff;

import edu.harvard.hul.ois.jhove.AESAudioMetadata;
import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.module.AiffModule;
import edu.harvard.hul.ois.jhove.module.iff.Chunk;
import edu.harvard.hul.ois.jhove.module.iff.ChunkHeader;
import java.io.DataInputStream;
import java.io.IOException;

public class ApplicationChunk
extends Chunk {
    public ApplicationChunk(AiffModule aiffModule, ChunkHeader chunkHeader, DataInputStream dataInputStream) {
        super(aiffModule, chunkHeader, dataInputStream);
    }

    public boolean readChunk(RepInfo repInfo) throws IOException {
        AiffModule aiffModule = (AiffModule)this._module;
        String string = aiffModule.read4Chars(this._dstream);
        byte[] byArray = new byte[(int)(this.bytesLeft - 4L)];
        ModuleBase.readByteBuf((DataInputStream)this._dstream, (byte[])byArray, (ModuleBase)this._module);
        Property[] propertyArray = new Property[2];
        propertyArray[0] = new Property("ApplicationSignature", PropertyType.STRING, (Object)string);
        AESAudioMetadata aESAudioMetadata = aiffModule.getAESMetadata();
        aESAudioMetadata.setAppSpecificData(string);
        if ("stoc".equals(string) || "pdos".equals(string)) {
            String string2 = aiffModule.readPascalString(this._dstream);
            this.bytesLeft -= (long)(string2.length() + 1);
            aiffModule.skipBytes(this._dstream, (int)this.bytesLeft, aiffModule);
            propertyArray[1] = new Property("ApplicationName", PropertyType.STRING, (Object)string2);
        } else {
            propertyArray[1] = new Property("Data", PropertyType.BYTE, PropertyArity.ARRAY, (Object)byArray);
        }
        aiffModule.addAiffProperty(new Property("Application", PropertyType.PROPERTY, PropertyArity.ARRAY, (Object)propertyArray));
        return true;
    }
}

