/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.jpeg2000;

import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.JhoveBase;
import edu.harvard.hul.ois.jhove.Message;
import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.module.jpeg2000.BoxHolder;
import edu.harvard.hul.ois.jhove.module.jpeg2000.JP2Box;
import edu.harvard.hul.ois.jhove.module.jpeg2000.JP2Strings;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;

public class DigSignatureBox
extends JP2Box {
    public DigSignatureBox(RandomAccessFile randomAccessFile, BoxHolder boxHolder) {
        super(randomAccessFile, boxHolder);
    }

    public boolean readBox() throws IOException {
        this.initBytesRead();
        int n = (int)this._boxHeader.getDataLength();
        ArrayList<Property> arrayList = new ArrayList<Property>(10);
        JhoveBase jhoveBase = this._module.getBase();
        boolean bl = jhoveBase.getShowRawFlag();
        int n2 = ModuleBase.readUnsignedByte((DataInputStream)this._dstrm, (ModuleBase)this._module);
        if (n2 > 5) {
            this._repInfo.setMessage((Message)new ErrorMessage("Unknown digital signature type", this._module.getFilePos()));
            this._repInfo.setValid(false);
        }
        arrayList.add(this._module.addIntegerProperty("Type", n2, JP2Strings.digitalSigTypeStr));
        int n3 = ModuleBase.readUnsignedByte((DataInputStream)this._dstrm, (ModuleBase)this._module);
        if (n3 > 1) {
            this._repInfo.setMessage((Message)new ErrorMessage("Unknown digital signature pointer type", this._module.getFilePos()));
            this._repInfo.setValid(false);
        }
        arrayList.add(this._module.addIntegerProperty("PointerType", n2, JP2Strings.digitalSigPtrTypeStr));
        n -= 2;
        long l = 0L;
        long l2 = 0L;
        if (n3 == 1) {
            l = this._module.readSignedLong(this._dstrm);
            l2 = this._module.readSignedLong(this._dstrm);
            arrayList.add(new Property("Offset", PropertyType.LONG, (Object)new Long(l)));
            arrayList.add(new Property("Length", PropertyType.LONG, (Object)new Long(l2)));
            n -= 8;
        }
        byte[] byArray = new byte[n];
        ModuleBase.readByteBuf((DataInputStream)this._dstrm, (byte[])byArray, (ModuleBase)this._module);
        if (n2 == 0 || n2 == 1) {
            try {
                if (n3 == 0) {
                    l = 0L;
                    l2 = this._raf.length();
                }
                arrayList.add(new Property("Valid", PropertyType.BOOLEAN, (Object)new Boolean(this.isSigValid(n2, l, l2, byArray))));
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this._module.addDigitalSignatureProp(new Property("DigitalSignature", PropertyType.PROPERTY, PropertyArity.LIST, arrayList));
        this.finalizeBytesRead();
        return true;
    }

    protected String getSelfPropName() {
        return "Digital Signature Box";
    }

    private boolean isSigValid(int n, long l, long l2, byte[] byArray) throws NoSuchAlgorithmException, IOException {
        MessageDigest messageDigest = n == 0 ? MessageDigest.getInstance("MD5") : MessageDigest.getInstance("SHA-1");
        try {
            int n2;
            this._raf.seek(l);
            int n3 = l2 < 65536L ? (int)l2 : 65536;
            byte[] byArray2 = new byte[n3];
            while (l2 > 0L) {
                int n4 = l2 < (long)n3 ? (int)l2 : n3;
                n2 = this._raf.read(byArray2, 0, n4);
                messageDigest.update(byArray2, 0, n2);
            }
            byte[] byArray3 = messageDigest.digest();
            if (byArray3.length != byArray.length) {
                return false;
            }
            for (n2 = 0; n2 < byArray.length; ++n2) {
                if (byArray3[n2] == byArray[n2]) continue;
                return false;
            }
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }
}

