/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.pdf;

import edu.harvard.hul.ois.jhove.module.PdfModule;
import edu.harvard.hul.ois.jhove.module.pdf.Parser;
import edu.harvard.hul.ois.jhove.module.pdf.PdfArray;
import edu.harvard.hul.ois.jhove.module.pdf.PdfDictionary;
import edu.harvard.hul.ois.jhove.module.pdf.PdfObject;
import edu.harvard.hul.ois.jhove.module.pdf.PdfSimpleObject;
import edu.harvard.hul.ois.jhove.module.pdf.PdfStream;
import java.io.RandomAccessFile;
import java.util.Iterator;
import java.util.Vector;

public abstract class PdfProfile {
    protected PdfModule _module;
    protected String _profileText;
    protected Parser _parser;
    protected RandomAccessFile _raf;
    private boolean _alreadyOK;

    public PdfProfile(PdfModule pdfModule) {
        this._module = pdfModule;
    }

    public boolean isAlreadyOK() {
        return this._alreadyOK;
    }

    public final boolean satisfiesProfile(RandomAccessFile randomAccessFile, Parser parser) {
        this._raf = randomAccessFile;
        this._parser = parser;
        boolean bl = this.satisfiesThisProfile();
        if (bl) {
            this._alreadyOK = true;
        }
        return bl;
    }

    public abstract boolean satisfiesThisProfile();

    public String getText() {
        return this._profileText;
    }

    protected boolean hasFilters(PdfObject pdfObject, String[] stringArray) {
        try {
            if (pdfObject == null) {
                return false;
            }
            if (pdfObject instanceof PdfSimpleObject) {
                String string = ((PdfSimpleObject)pdfObject).getStringValue();
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!stringArray[i].equals(string)) continue;
                    return true;
                }
            } else {
                Vector vector = ((PdfArray)pdfObject).getContent();
                for (int i = 0; i < vector.size(); ++i) {
                    PdfSimpleObject pdfSimpleObject = (PdfSimpleObject)vector.elementAt(i);
                    String string = pdfSimpleObject.getStringValue();
                    for (int j = 0; j < stringArray.length; ++j) {
                        if (!stringArray[j].equals(string)) continue;
                        return true;
                    }
                }
            }
        }
        catch (Exception exception) {
            return false;
        }
        return false;
    }

    protected boolean xObjectsOK(PdfDictionary pdfDictionary) {
        if (pdfDictionary == null) {
            return true;
        }
        try {
            Iterator iterator = pdfDictionary.iterator();
            while (iterator.hasNext()) {
                PdfDictionary pdfDictionary2;
                PdfObject pdfObject = this._module.resolveIndirectObject((PdfObject)iterator.next());
                if (pdfObject instanceof PdfStream) {
                    pdfObject = ((PdfStream)pdfObject).getDict();
                }
                if (!(pdfObject instanceof PdfDictionary) || this.xObjectOK(pdfDictionary2 = (PdfDictionary)pdfObject)) continue;
                return false;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    protected boolean xObjectOK(PdfDictionary pdfDictionary) {
        return true;
    }
}

