/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.wave;

import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.module.WaveModule;
import edu.harvard.hul.ois.jhove.module.iff.Chunk;
import edu.harvard.hul.ois.jhove.module.iff.ChunkHeader;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;

public class CueChunk
extends Chunk {
    public CueChunk(ModuleBase moduleBase, ChunkHeader chunkHeader, DataInputStream dataInputStream) {
        super(moduleBase, chunkHeader, dataInputStream);
    }

    public boolean readChunk(RepInfo repInfo) throws IOException {
        WaveModule waveModule = (WaveModule)this._module;
        int n = (int)waveModule.readUnsignedInt(this._dstream);
        ArrayList<Property> arrayList = new ArrayList<Property>(n);
        for (int i = 0; i < n; ++i) {
            long l = waveModule.readUnsignedInt(this._dstream);
            long l2 = waveModule.readUnsignedInt(this._dstream);
            String string = waveModule.read4Chars(this._dstream);
            long l3 = waveModule.readUnsignedInt(this._dstream);
            long l4 = waveModule.readUnsignedInt(this._dstream);
            long l5 = waveModule.readUnsignedInt(this._dstream);
            Property[] propertyArray = new Property[]{new Property("ID", PropertyType.LONG, (Object)new Long(l)), new Property("Position", PropertyType.LONG, (Object)new Long(l2)), new Property("DataChunkID", PropertyType.STRING, (Object)string), new Property("BlockStart", PropertyType.LONG, (Object)new Long(l3)), new Property("SampleOffset", PropertyType.LONG, (Object)new Long(l4))};
            arrayList.add(new Property("CuePoint", PropertyType.PROPERTY, PropertyArity.ARRAY, (Object)propertyArray));
        }
        waveModule.addWaveProperty(new Property("Cue", PropertyType.PROPERTY, PropertyArity.LIST, arrayList));
        return true;
    }
}

