/**
 *	Copyright (C) 2011-2015 Docuteam GmbH
 *
 *	This program is free software: you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 3
 *	as published by the Free Software Foundation.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package ch.docuteam.darc.exceptions;

import ch.docuteam.darc.mets.structmap.NodeAbstract;

/**
 * @author denis
 *
 */
public class CantSetSubmitRequestedMandatoryMDElementsNotSetException extends Exception
{
	private NodeAbstract		node;

	public CantSetSubmitRequestedMandatoryMDElementsNotSetException(NodeAbstract node)
	{
		super("Node '" + node.getPathString() + "': Can't set submitRequested because some mandatory metadata elements are not set");

		this.node = node;
	}

	//	--------		Accessing			-------------------------------------------------------

	public NodeAbstract getNode()
	{
		return this.node;
	}

}
