/**
 *	Copyright (C) 2011-2015 Docuteam GmbH
 *
 *	This program is free software: you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 3
 *	as published by the Free Software Foundation.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
/**
 *	Copyright (C) 2011-2015 Docuteam GmbH
 *
 *	This program is free software: you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 3
 *	as published by the Free Software Foundation.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package ch.docuteam.tools.gui;

import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

/**
 * @author denis
 *
 *This is a subclass of JTable. It can be configured that for some columns, the cell content is displayed as the cell's toolTipText when the mouse pointer hovers above the cell.
 */
public class JTableWithDynamicToolTipTexts extends JTable
{
	//	===========================================================================================
	//	========	Structure				=======================================================
	//	===========================================================================================

	//	========	Static Final Public		=======================================================

	//	========	Static Final Private	=======================================================

	//	========	Static Public			=======================================================

	//	========	Static Private			=======================================================

	//	========	Instance Public			=======================================================

	//	========	Instance Private		=======================================================

	protected int[]		toolTipTextColumnIndexes = new int[0];

	//	===========================================================================================
	//	========	Main					=======================================================
	//	===========================================================================================

	/**
	 * This is only for testing:
	 */
	static public void main(String[] args)
	{
		JFrame frame = new JFrame();
		frame.addWindowListener(new WindowAdapter() { @Override public void windowClosing(WindowEvent e) { System.exit(0); }});
		TableModel tableModel = new AbstractTableModel()
		{
			@Override public int getColumnCount() { return 2; }
			@Override public int getRowCount() { return 10; }
			@Override public Object getValueAt(int rowIndex, int columnIndex) { return "Row: " + rowIndex + " Column: " + columnIndex + " 1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890"; }
		};
		JTableWithDynamicToolTipTexts jTable = new JTableWithDynamicToolTipTexts(tableModel, 0, 1);
		frame.add(new JScrollPane(jTable));
		frame.pack();
		frame.setVisible(true);
	}

	//	===========================================================================================
	//	========	Methods					=======================================================
	//	===========================================================================================

	//	========	Static Initializer		=======================================================

	//	========	Constructors Public		=======================================================

	/**
	 * Set the column indexes for which the toolTextTips shall be displayed using the vararg toolTipTextColumnIndexes
	 */
	public JTableWithDynamicToolTipTexts(int... toolTipTextColumnIndexes)
	{
		super();
		this.toolTipTextColumnIndexes = toolTipTextColumnIndexes;
	}


	/**
	 * Set the column indexes for which the toolTextTips shall be displayed using the vararg toolTipTextColumnIndexes
	 */
	public JTableWithDynamicToolTipTexts(TableModel tableModel, int... toolTipTextColumnIndexes)
	{
		super(tableModel);
		this.toolTipTextColumnIndexes = toolTipTextColumnIndexes;
	}

	//	========	Constructors Private	=======================================================

	//	========	Static Public			=======================================================

	//	========	Static Private			=======================================================

	//	========	Instance Public			=======================================================

	//	--------		Accessing			-------------------------------------------------------
	//	--------		Inquiring			-------------------------------------------------------
	//	--------		Interface			-------------------------------------------------------

	@Override
	public String getToolTipText(MouseEvent e)
	{
		if (this.toolTipTextColumnIndexes.length == 0)		return null;

		java.awt.Point p = e.getPoint();
		int rowIndex = this.rowAtPoint(p);
		int colIndex = this.columnAtPoint(p);

		int realColumnIndex = this.convertColumnIndexToModel(colIndex);

		for (int i: this.toolTipTextColumnIndexes)
		{
			if (i == realColumnIndex)
			{
				Object o = this.getValueAt(rowIndex, colIndex);
				if (o == null)		return null;

				return o.toString().trim();
			}
		}

		return null;
	}

	//	--------		Business Ops		-------------------------------------------------------
	//	--------		Persistence			-------------------------------------------------------
	//	--------		Support				-------------------------------------------------------
	//	--------		Utilities			-------------------------------------------------------
	//	---------		Misc				-------------------------------------------------------
	//	--------		Debugging			-------------------------------------------------------
	//	---------		Temporary			-------------------------------------------------------

	//	========	Instance Private		=======================================================

	//	--------		Initializing		-------------------------------------------------------
	//	--------		Accessing			-------------------------------------------------------
	//	--------		Inquiring			-------------------------------------------------------
	//	--------		Interface			-------------------------------------------------------
	//	--------		Business Ops		-------------------------------------------------------
	//	--------		Persistence			-------------------------------------------------------
	//	--------		Support				-------------------------------------------------------
	//	--------		Utilities			-------------------------------------------------------
	//	---------		Misc				-------------------------------------------------------
	//	--------		Debugging			-------------------------------------------------------
	//	---------		Temporary			-------------------------------------------------------

	//	===========================================================================================
	//	========	Inner Classes			=======================================================
	//	===========================================================================================

}
