/**
 *	Copyright (C) 2011-2015 Docuteam GmbH
 *
 *	This program is free software: you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 3
 *	as published by the Free Software Foundation.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package ch.docuteam.converter.admin;


/**
 * @author denis
 *
 * CHANGES HISTORY:
 *
 * Version 1.1.0:
 * 09.04.2015 (Andreas):
 * reintegrate branch "20150407_eug_fileformats_without_migration":
 * 		- FileConverter: skip migration if no applicationID is provided in migration-config.xml (including related unittests)
 * 08.04.2015 (Andreas):
 * lib/docuteam-tools-1.10.6: Use final tagged version
 * 		- config/*: updated DROID signature files
 * 		- string.StringUtil: new method isDecimal(String)
 * 		- lib/droid*: clean droid libraries
 * 31.03.2015 (Andreas):
 * change version to 1.1.0
 * integrate branch from /branches/20150331-nf-use-intermediary-name-as-target:
 * 		- FileConverter:
 * 			- Use a unique temporary filename as conversion target, then rename it to the correct name
 * 			- Do not duplicate the extension even if the output file will have the same name as the input file
 * 			- Cleanup commented code
 * 		- unittest.FileConverter:
 * 			- include ghostscript for pdf conversion
 * 			- expect PDF/A output from OpenOffice
 * 		- unittest/files/config/migration-config_OSX.xml: expect PDF/A output from OpenOffice
 * 31.03.2015 (Andreas):
 * integrate branch from /branches/targetPronom with several values ce:
 * 		- FileConverter: accept multiple target pronom IDs now (comma separated)
 * 		- unittest.converter.FileConverter_MultiplePuids: proper tests with pdf examples that return different output formats
 * 		- unittest.converter.FileConverter_ParameterSeparator: renamed class
 * 		- unittest.converter.FileConverter: expect PDF/A as output from OpenOffice
 * 		- unittest/files/config/migration-config_*.xml: expect PDF/A as output from OpenOffice
 * 		- unittest/files/config/migration-config_pdf*.xml: remove unnecessary config files
 * 		- unittest/files/FileConverterMultiplePuids: added testfiles
 * 10.03.2015 (Andreas):
 * lib/docuteam-tools-1.10.6.jar: use most recent version with string.StringUtil.isDecimal(string)
 * 24.02.2015 (Christian):
 * config_dist/migration-config.xml, unittest/files/config/migration-config_Linux.xml, unittest/files/config/migration-config_OSX.xml, unittest/files/config/migration-config_Win.xml, unittest/files/config/migration-config_pdf_Linux.xml, unittest/files/config/migration-config_pdf_OSX.xml, unittest/files/config/migration-config_pdf_Win.xml: changed ghostscript parameter to -sColorConversionStrategy=/UseDeviceIndependentColor#
 * 17.02.2015 (Andreas):
 * build.xml: set java compatibility to 1.7
 * lib/docuteam-tools-1.10.6.jar: use java 1.7 compatible build
 * 13.02.2015 (Andreas):
 * lib/*: use most recent docuteam tools library with modified DROID libraries
 * 09.02.2015 (Christian):
 * lib/docuteam-tools: updated to version 1.10.5 (now really)
 * 28.01.2015 (Christian):
 * lib/docuteam-tools: updated to version 1.10.5
 * lib/droid-*: updated to version 6.1.5
 * lib/poi: updated to version 3.11
 * build.xml compiler settings updated to java 8
 *
 * Version 1.0.3:
 * 12.11.2014 (Andreas):
 * Use tagged version of tools 1.10.4:
 * 		file.FileUtil: add method to get the human readable size of a file
 * 		util.JavaInterpreter: set method execute(Object, String) as deprecated; changed method execute(Object, Object, String) to method using varargs as: execute(String, Object...)
 * 05.09.2014 (Andreas):
 * Use current version of tools 1.10.4 with updated license information
 * licenses/*: general cleanup
 * 01.09.2014 (Andreas):
 * unittest.files.config.migration-config_*.xml: correct windows paths
 *
 * Version 1.0.2:
 * 27.08.2014 (Christian):
 * Changed dependency from docuteam-tools-1.10.2 to docuteam-tools-1.10.3.
 * 14.07.2014 (Christian):
 * Added constant DefaultCommandlineSeparator to converter.FileConverter
 * Added constant AlternativeCommandlineSeparators to converter.FileConverter
 * Added function determineApplicableSeparator. Determines a separator (one of AlternativeCommandlineSeparator and DefaultCommandlineSeparator that is not used in the name of the file to be converted.
 * 23.05.2014 (Denis):
 * Use current version of tools 1.10.2 with extension:
 * 		added new method: File EnvironmentVariable.getFileTryCurrentContextFirst(String environmentVariableName, String relativeFileName). Returns File or null if resulting file does not exist.
 * 29.04.2014 (Andreas):
 * Version 1.0.2 initial.
 *
 * Version 1.0.1:
 * 29.04.2014 (Andreas):
 * Use current version of tools 1.10.1 with extension:
 * 		updated DROID signature file to enhance support for PDF/A
 * 15.04.2014 (Denis):
 * Use current version of tools 1.10.1 with extension:
 * 		out.Logger: Added public method getLogger() that returns the logger for the calling class. When using this method, it is possible
 * 				to output the name and line number of the method where the logging is issued in.
 * 		exception.Exception, exception.ExceptionCollector: Improve output as String.
 * 04.04.2014 (Denis):
 * Version 1.0.1 initial.
 *
 * Version 1.0.0:
 * 04.04.2014 (Denis):
 * Use tagged version of tools 1.10.0.
 * Tagged as Version 1.0.0.
 * 03.04.2014 (Andreas):
 * FileConverter: remove code that will append all available information as parameters, even if they were not specified in the configuration
 * config/migration-config.xml: add usage information, add "flac" file format, add application definition for PDF-Tools, disable video migration by default, clean formatting
 * unittest/migration-config_XXX.xml: clean formatting
 * 02.04.2014 (Denis):
 * Use current version of tools 1.10.0.
 * 28.03.2014 (Andreas):
 * unittest.converter.FileConverter_PDFToolsConverter: use test instance of PDF-Tools service
 * 27.03.2014 (Andreas):
 * config/migration-config.xml: simplify default parameters for openoffice
 * 26.03.2014 (Andreas):
 * extend with openoffice for linux
 * Use current version of tools 1.10.0 with correction:
 * 		os.SystemProcessCantLaunchApplicationException, os.SystemProcess: Throw specific exception when Desktop can't launch or associate an application with a file. * 21.03.2014 (Andreas):
 * extend migration-config files.
 * FileConverter: define some methods as public: calculateDestinationFilePath, getMigrationInstructions
 * 21.03.2014 (Günter):
 * update migration-config with word perfect puid and mimetype
 * 20.03.2014 (Denis):
 * Use current version of tools 1.10.0 with correction:
 * 		file.MetadataProviderDROID: Use current versions of DROID-signature and container-signature files.
 * 05.03.2014 (Denis):
 * unittest.converter.*: Adapted unittests for Linux.
 * Use current version of tools 1.10.0.
 * 04.03.2014 (Denis):
 * FileConverter$PDFToolsConverter: The PDFToolsConverter now checks by himself if the required VM argument "-Djava.library.path" exists and points to the correct folder.
 * 27.02.2014 (Denis):
 * FileConverter: Handle too long file paths under Windows by performing the conversion in the temp folder.
 * 17.02.2014 (Denis):
 * Use current version of tools 1.10.0 with correction:
 * 		gui.SystemOutView: Minor visual improvements in the GUI.
 * 13.02.2014 (Denis):
 * FileConverter$PDFToolsConverter: Include PDFTools Converter.
 * 12.02.2014 (Denis):
 * Initial version 1.0.0.
 *
 */
public abstract class Version
{
	static public final String Product = "docuteam converter";
	static public final String Number = "1.1.0";
	static public final String LastChange = "09.04.2015";

	/**
	 * This main method is being used by the ant build script to be able to add a version number to the compiled jar file.
	 *
	 * @param args No parameters are expected.
	 */
	public static void main(String[] args)
	{
		System.out.println(Number);
	}
}
