/**
 *	Copyright (C) 2011-2015 Docuteam GmbH
 *
 *	This program is free software: you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 3
 *	as published by the Free Software Foundation.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package ch.docuteam.tools.admin;


/**
 * @author denis
 *
 * CHANGES HISTORY:
 * 
 * Version 1.10.6:
 * 31.03.2015 (Christian):
 * unittest.tools.file.MetadataProviderDROID: Adapted unittests to new signature definitions of DROID
 * file.MetadataProviderDROID: updated file names for droid signature files
 * config_dist/container-signature-20150327.xml: replaced droid signature file by new version
 * config_dist/DROID_SignatureFile_V82.xml: replaced droid signature file by new version
 * 25.02.2015 (Christian):
 * string.StringUtil: added new method isDecimal(string) checks if provided parameter is a valid decimal value
 * unittest.tools.string.StringUtil: added new test method isDecimal()
 * 17.02.2015 (Andreas):
 * build.xml: set java compatibility to 1.7
 * 12.02.2015 (Andreas):
 * build.xml: add target to fix droid libraries
 * lib/droid*.jar: remove unwanted log4j configurations and classpaths from jar files
 * 
 * Version 1.10.5:
 * 26.01.2015 (Christian):
 * build.xml: set java version to 1.8
 * lib/droid-command-line, lib/droid-container, lib/droid-core, lib/droid-core-interfaces: version update to 6.1.5
 * lib/poi: version update to 3.11
 * 16.01.2015 (Andreas):
 * file.MetadataProviderDROID: add method setExtensionUsage to select the level of using extensions to identify file formats (currently, it was hardcoded to full extension matching which potentially identified wrong formats).
 * 14.01.2015 (Christian):
 * file.FileUtil: reimplemented method parseStringAsFileSize, added unittest
 * 08.01.2015 (Christian):
 * updated (and added where missing) copyright messages
 * 11.12.2014 (Andreas):
 * file.FileUtil: added methods to parse a string as file size and get a human readable size from a long number.
 * 
 * Version 1.10.4:
 * 05.11.2014 (Christian):
 * unittest.tools.out.MailSender: changed back to svn@docuteam.ch
 * unittest.tools.os.SystemProcess added text to error message concerning opening a folder in a window on ubuntu.
 * unittest.tools.file.PropertyFileOK: PropertyFile is now explicitly initialized
 * unittest.tools.file.PropertyFileNOK: PropertyFile is now explicitly initialized
 * unittest.tools.file.PropertyFileWithEnvironmentVariable: PropertyFile is now explicitly initialized
 * 04.11.2014 (Christian):
 * unittest.tools.util.JavaInterpreter corrected Testcase testMultipleParameters
 * 30.10.2014 (Andreas):
 * file.FileUtil: add method to get the human readable size of a file
 * 20.10.2014 (Christian):
 * util.JavaInterpreter: set method execute(Object, String) as deprecated; changed method execute(Object, Object, String) to method using varargs as: execute(String, Object...)
 * 20.10.2014 (Andreas):
 * unittest.tools.file.MetadataProviderDROID: add test for JPX (JPEG 2000 part 2)
 * 07.10.2014 (Christian):
 * util.JavaInterpreter: added method execute with three parameters (two objects and an executable script)
 * 05.09.2014 (Andreas):
 * licenses/_readme.txt: typo
 * 27.08.2014 (Christian)
 * Version 1.10.4 initial
 * 
 * Version 1.10.3:
 * 27.08.2014 (Christian)
 * FileUtil.basicCopyFilePhysically: moved stream creations into try..catch clause, so the streams are closed even if Exceptions are thrown
 * 30.06.2014 (Andreas):
 * Version 1.10.3 initial
 *
 * Version 1.10.2:
 * 20.06.2014 (Denis):
 * translations.I18N: Add methods translate_NoCheck(String word) and translate_NoCheck(String word, Object... objects) to avoid exception when I18N is not initialized.
 * 11.06.2014 (Denis):
 * string.StringUtil: Added methods substring(String string, int from) and substring(String string, int from, int to).
 * 		Both "from" and "to" can be negative, counting then from the right of the string backwards.
 * 04.06.2014 (Andreas):
 * MetadataProviderDROID: Use full extension matching
 * 28.05.2014 (Denis):
 * string.StringUtil: Added methods containsAll(String, String...), containsAll(String, List<String>), containsAny(String, String...), and containsAny(String, List<String>).
 * 08.05.2014 (Christian)
 * added new method: File EnvironmentVariable.getFileTryCurrentContextFirst(String environmentVariableName, String relativeFileName). Returns File or null if resulting file does not exist.
 * 29.04.2014 (Andreas):
 * Version 1.10.2 initial.
 *
 * Version 1.10.1:
 * 29.04.2014 (Andreas):
 * finalize version
 * 25.04.2014 (Andreas):
 * config/DROID_SignatureFile_V74.xml: new signature file that correctly identifies the PDFs produced by PDF-Tools' converter as PDF/A
 * 15.04.2014 (Denis):
 * out.Logger: Added public method getLogger() that returns the logger for the calling class. When using this method, it is possible
 * 		to output the name and line number of the method where the logging is issued in.
 * 08.04.2014 (Denis):
 * exception.Exception, exception.ExceptionCollector: Improve output as String.
 * 04.04.2014 (Denis):
 * Version 1.10.1 initial.
 *
 * Version 1.10.0:
 * 03.04.2014 (Denis):
 * Tagged as "Version 1.10.0"
 * 01.04.2014 (Denis):
 * config_dist/log4j.xml: Add category to avoid message "will always scan up to maximum bytes." from DROID.
 * 25.03.2014 (Denis):
 * os.SystemProcessCantLaunchApplicationException, os.SystemProcess:
 * 		Throw specific exception when Desktop can't launch or associate an application with a file.
 * 20.03.2014 (Denis):
 * file.MetadataProviderDROID: Use current versions of DROID-signature and container-signature files.
 * 11.03.2014 (Denis):
 * file.FileUtil: Prohibit "..", as legal file name generally.
 * 05.03.2014 (Denis):
 * Cleanup: delete all deprecated methods.
 * 04.03.2014 (Denis):
 * file.FileUtil: Prohibit "/", "\", and "." as legal file names generally.
 * unittests: Make the unit tests run under Windows again.
 * 28.02.2014 (Andreas):
 * out.MailSender: Proper error message for incorrect mail addresses
 * 27.02.2014 (Denis):
 * file.FileUtil: Extended so that *all* methods can now be called either with a String or a File as parameter.
 * 17.02.2014 (Denis):
 * gui.SystemOutView: Minor visual improvements in the GUI.
 * 11.02.2014 (Denis):
 * os.SystemClipboard: New class. Can be used to get text from and put text into the system clipboard.
 * gui.SystemOutView:
 * 		Add "Copy" button to copy the content of the text area into the system clipboard.
 * 		Add method to optionally set an "additional info text" string, which is added to the text area string when copying the text to the clipboard.
 * file.PropertyFile: Add method "getKeys()";
 * 05.02.2014 (Denis):
 * 99% approved for Linux (only one UnitTest fails: SystemProcess.testOpenExternallyOK():176:
 * 		ch.docuteam.tools.os.SystemProcess.openExternally("src/ch/docuteam/unittest/files/FileFilter/Folder");
 * Initial Version 1.10.0.
 * os.OperatingSystem: The interface has changed:
 * 		The results of javaTempDir() and userHome() now always return the file path with a trailing File.separator.
 * admin.PackageStatistics: Moved to package "stats".
 * Refactoring: Renamed package "ch.docuteam.docutools" to "ch.docuteam.tools".
 *
 *
 * Version 1.9.1:
 * 28.01.2014 (Denis):
 * Adapted some UnitTests for Linux.
 * file.FileUtil: New method "countLines()".
 * unittest.file.PropertyFileNoSubclass: Correction.
 * 23.01.2014 (Andi):
 * Unittests: typing errors (captial/small) letters
 * 15.01.2014 (Denis):
 * All java sources: Change copyright message from "2011-2013" to "2011-2014".
 * 08.01.2014 (Denis):
 * gui.GUIUtil: new Class.
 * file.PropertyFile: Added new method get(String key, String ifAbsent, String ifEmpty) with additional option "ifEmpty".
 * 19.12.2013 (Denis):
 * Initial V1.9.1.
 *
 * Version 1.9.0:
 * -----	Commited into SVN:
 * 19.12.2013 (Denis):
 * Created Tag "Version 1.9.0" because used in curator V2.5.4.
 * 11.12.2013 (Denis):
 * file.FileUtil: Added methods moveTo(String, String) and moveTo(File, File).
 * 05.12.2013 (Denis):
 * gui.SystemOutView: Is not always in front any more.
 * 05.11.2013 (Andreas):
 * out.MailSender: allow several comma-separated recipients.
 * 04.11.2013 (Denis):
 * file.PropertyFile: new method: getProperties() returns an instance of Properties with the content of the underlying property file.
 * 18.10.2013 (Denis):
 * Version 1.9.0 initial.
 * file.FileFilter: The Interface changed!
 * 		Now the file filters are already instanciated - to use one, simply pick it (like: 'FileFilter.METSFiles').
 * 		Now the file filters implement the Interface 'java.io.FilenameFilter' in addition to the Interface 'java.io.FileFilter'.
 * 		Marked some FileFilters as deprecated and created copies with better names.
 *
 * 1.8.4 (Denis, 10.10.2013):
 * Initial V1.8.4.
 * Switch to Java 7.
 * build.xml: Refactoring.
 * out.Logger: Added static method reInitialize() which re-initializes log4j.
 * out.SystemOutRedirector: When redirecting STDOUT and STDERR, re-initialize the class out.Logger.
 * exception.Exception: Made it look more like a standard java exception, with fileName, lineNumber, and the method "printStackTrace()".
 * exception.ExceptionCollector: Added method "printStackTrace()".
 * Switch back to Java 6.
 * os.SystemProcess: Correction when opening a file externally in Windows: use "Desktop" now as the default method.
 * gui.SmallPeskyMessageWindow, gui.SmallPeskyProgressBarWindow: Can now be opened blocking the underlying parent window.
 * gui.JTableWithSpecificCellEditorPerRow: Added method "commitOrCancelCurrentCellEditor()" to commit (or cancel if commit fails) the current cell editor.
 * build.xml: Correction in target manifest.classpath.
 * out.MailSender: Correction: The body can now contain umlauts. Added unit tests for out.MailSender.
 * string.Pattern: New class for simple pattern matching (* and ? wildcards allowed unrestrictedly, multiple patterns supported).
 * file.PropertyFile: Log duplicate keys at 'warn' level.
 * gui.SmallPesky*Window: Correction to avoid NullPointerException in certain cases.
 * os.EnvironmentVariable: Environment variables can be resolved in normal strings, too.
 * file.PropertyFile: Resolve environment variables in property values.
 * os.EnvironmentVariable: Added method 'getAll()' which returns a Map with all currently available environment variables.
 * lib/slf4j-api-1.6.6.jar, lib/slf-log4j12-1.6.6.jar, lib/jul-to-slf4j-1.6.6.jar, out.Logger:
 * 		Redirect jul-logging via slf to log4j.
 *       (Andreas, 15.10.2013):
 * out.MailSender: provide methods for attachments as well
 * updated license information on used libraries
 * Created Tag "Version 1.8.4".
 *
 * 1.8.3 (Denis, 15.04.2013):
 * translation.I18N: This class is not abstract any more: it can be used statically as before, but in addition instances can be created.
 * translation.I18N: This class is again abstract. Instances of translation.I18N.Translator can be created for non-default translations.
 * file.exception.DROIDNoIdentificationFoundException, file.exception.DROIDMultipleIdentificationsFoundException:
 * 		Improved these two exceptions to show more information when thrown.
 * unittest.docutools.file.MetadataProviderDROID: Extended UnitTests to test a .bmp and .properties file.
 * unittest.docutools.file.MetadataProviderDROID: Extended UnitTests to test another .bmp file.
 * file.FileUtil: Added method "appendSuffixToFileName(String, String)".
 * file.FileUtil: Corrections in the methods "appendSuffixToFileName()", "asFilePathWithoutExtension()", "asFileNameWithoutExtension()", and "asFileNameExtension()":
 * 		Wrong results were returned when the path, but not the file had an extension.
 *
 * 1.8.2 (Denis, 06.03.2013):
 * util.JavaInterpreter: Added.
 * file.Zipper: When zipping, replace in the file names all backslashes by "/", otherwise the created zip file is not portable from Win to OSX.
 * file.FileUtil: Correction in method isFileNameAllowed(String).
 *
 * 1.8.1 (Denis, 17.01.2013):
 * All java sources: Change copyright message from "2011-2012" to "2011-2013".
 * lib/*,
 * file.MetadataProviderDROID,
 * file.MetadataProviderDROID_IdentificationResult,
 * uk.gov.nationalarchives.droid.core.BinarySignatureIdentifier_Extended:
 * 		Hieve up the DROID libs from version 5.0.3 to 6.1. Throw now exceptions if something goes wrong (before: return null).
 * 		Extend UnitTests to regard many new additional test files.
 * file.MetadataProviderJHOVE: Added convenience methods like in MetadataProviderDROID. Extend UnitTests to regard many new additional test files.
 *
 * 1.8.0 (Denis, 19.12.2012):
 * Grand refactoring:
 * ****	Changed the package of many classes!
 * 		Moved all Exceptions from the package "exceptions" to "file.exception".
 * 		Moved classes EnvironmentVariable, OperatingSystem, OSXAdapter, SystemProcess, and SystemProcessException from package "util" to "os".
 * 		Moved classes Exception, ExceptionCollector, and ExceptionCollectorException from package "util" to "exception".
 *
 * 1.7.2 (Denis, 29.11.2012):
 * string.ToolTipText: New Interface "ToolTipText".
 * file.FileFilter: New FileFilters "SIP" and "SIPorZIP".
 * file.FileFilter: Corrected FileFilters "METS" and "METSorZIP": Don't accept folders any more - one can still navigate through directories in the JFileChooser.
 *
 * 1.7.1 (Denis, 01.11.2012):
 * file.FileUtil: Added method setWritable(File) and basicSetWritableRecursively(File) for setting files and whole directory trees to be writable.
 * file.FileUtil: Bug fix: During copying, when a destination folder is not readable or not writable, ignore it and remember exception.
 *
 * 1.7.0 (Denis, 29.10.2012):
 * file.FileUtil: Added methods for copying with an additional boolean parameter to preserve the file's or folder's access rights.
 * file.FileUtil: Modified delete methods, to grant write access before deleting if necessary and possible.
 * file.FileUtil: When copying files or folders fails due to restricted read access, remember a FileIsNotReadableException in the ExceptionCollector, and continue.
 * ****	Changed the public interface of file.FileUtil:
 * file.FileUtil: Grand refactoring: Use now ExceptionCollector when problems occur during copying and deleting.
 * 		(Before, static List<String> DeleteErrorMessages was used to inform the caller about failures)
 * 		IMPORTANT NOTE: UnitTests don't work yet!
 * file.FileUtil, exceptions.FileUtilException, exceptions.FileUtilExceptionListException, exception.*:
 * 		Grand refactoring: Use local ExceptionList (not ExceptionCollector any more) when exceptions occur during copying and deleting.
 * file.FileUtil: Corrections in methods basicCopyToRecursively(), basicDeleteRecursively(), and basicDeleteOnExitRecursively():
 * 		Don't overwrite or delete restricted files and folders, but collect exceptions.
 * unittest.docutools.file.FileUtil: UnitTests for file.FileUtil.
 *
 * 1.6.6 (Denis, 11.10.2012):
 * Refactoring: Moved classes NextNumber and UniqueID from package "string" to "id".
 *
 * 1.6.5 (Denis, 04.10.2012):
 * Added class: JTableWithSpecificCellEditorPerRow.
 * Added interface: TableModelWithSpecificCellEditorPerRow.
 * Added class: string.NextNumber for getting unique numbers in ascending order (threadsafe).
 * file.FileUtil: Added methods createFileWithContent(File, String) and createFileWithContent(String, String).
 * file.FileUtil: Correction in method asFileNameWithoutExtension(String). Added method asFilePathWithoutExtension(String).
 * file.FileUtil: In Method setTempFolder(String), handle now correctly the parameter value null.
 *
 * 1.6.4 (Denis, 20.09.2012):
 * file.FileUtil: Added methods:
 * 		String asFileName(String)
 * 		String asParentPath(String)
 * 		String getFileContentAsString(File)
 *
 * 1.6.3 (Denis, 11.09.2012):
 * admin.PackageStatistics: Ignore any exception that may occur when instanciating classes.
 * unittest.admin.PackageStatistics: Removed class.
 *
 * 1.6.2 (Andreas, 27.08.2012):
 * MetadataProviderDROID: Do not use DOCUTOOLS_HOME anymore to find the signature file, but added methods to define an individual location
 *
 * 1.6.1 (Denis, 16.08.2012):
 * Added class: admin.PackageStatistics.
 *
 * 1.6.0 (Denis, 06.08.2012):
 * file.FileUtil, string.StringUtil: Moved following methods from class string.StringUtil to class file.FileUtil:
 * 		String asSafeFileName(String)
 * 		String asCanonicalFileName(String)
 * 		String asCanonicalFileName(File)
 * 		String asFileNameWithoutExtension(String)
 * 		String asFileNameExtension(String)
 * 		boolean isFileNameAllowed(String)
 *
 * 1.5.6 (Denis, 04.08.2012):
 * string.StringUtil: Added method String asCanonicalFileName(...);
 * licences.*: Added required software licenses to the project.
 * file.FileUtil: Added methods void deleteOnExit(...);
 *
 * 1.5.5 (Denis, 19.07.2012):
 * gui.SystemOutView: Added the possibility to suppress the automatic popping-up of the SystemOutView when output occurs.
 *
 * 1.5.4 (Denis, 16.07.2012):
 * Added class: util.OSXAdapter. This class handles the Mac OS X cmd-q event and the menu entry "About" and "Preferences".
 *
 * 1.5.3 (Denis, 07.06.2012):
 * string.StringUtil: Bug fix in method split(): Splitting an empty string now returns an empty array when 'ignoreEmptyTokens' = true,
 * 		and an array with 1 emtpy element when 'ignoreEmptyTokens' = false.
 *
 * 1.5.2 (Denis, 07.06.2012):
 * util.OperatingSystem: Added method javaTempDir() which returns the current temp dir path.
 * string.StringUtil: Added method isFileNameAllowed(String s) which returns true if the file name s is OK for the current OS, and false otherwise.
 * file.Util: Keep the original access rights when copying files or folders (VERY questionable!!! Still under construction).
 * string.StringUtil: Added method String concatSeparatedBy(Iterable<String> elements, String separator), which concats the elements with a separator between each.
 *
 * 1.5.1 (Denis, 23.05.2012):
 * file.Zipper: If the current user has no read access to a file or folder to be zipped, log it.
 * file.Util: When deleting files or folders, consider the case that the current user has no read or write access on a file or folder to be deleted.
 * translations.I18N: Add static public property 'AvailableLanguages' that contains an array of available language shortcuts.
 * 		Note: This property is 'hardcoded' for now, because that's easy and most probably won't change in the next 10 years or so.
 *
 * 1.5.0 (Denis, 18.05.2012):
 * Added class: ScrollableMessageDialog.
 * Added class: SmallPeskyMessageWindow.
 * Added class: SmallPeskyProgressBarWindow.
 * Both SmallPesky classes implement the Observer interface.
 * gui.LimitedIntegerTextField: Modified so that a min and max integer value can be supplied. Added getInteger() and setInteger() methods.
 * Changed the *interface* of class gui.LimitedIntegerTextField:
 * 		The constructors now behave differently: Don't set max. length and initial value, but min value and max value.
 * 		Bug fix: When NO max value is set, accept now any input length.
 *
 * 1.4.11 (Denis, 16.04.2012):
 * file.FileUtil: Added getter and setter for TempFolder.
 * util.Sound: Better exception handling when playing sound files.
 *
 * 1.4.10 (Denis, 19.03.2012):
 * Added class: gui.MultiLineLabel.
 *
 * 1.4.9 (Denis, 14.03.2012):
 * file.FileUtil: When copying files, don't zip them temporarily.
 * file.FileWithMetadata: When once tried to retrieve DROID or JHOVE metadata for a file, don't try again.
 *
 * 1.4.8 (Denis, 09.03.2012):
 * Added class: gui.LimitedTextArea.
 *
 * 1.4.7 (Denis, 05.03.2012):
 * file.Zipper: Handle correctly source files and folders with a drive specification at the beginning (like "D:/").
 * All sources: Changed the copyright message from 2011 to 2011-2012
 *
 * 1.4.6 (Denis, 09.02.2012):
 * util.OperatingSystem: Added static method userHome() that returns the current user's home directory path.
 *
 * 1.4.5 (Denis, 01.02.2012):
 * util.OperatingSystem: Added static method userLanguage() that returns the system language shortcut ("de", "en", "fr", etc.)
 *
 * 1.4.4 (Denis, 23.12.2011):
 * out.Logger: Added static method getLogger(String name) to (create if necessary and) return the Logger with this name.
 *
 * 1.4.3 (Denis, 19.12.2011):
 * file.FileUtil: In the methods copyTo() and copyToFolder() place the cleanup part (delete temporary files) into a finally block.
 *
 * 1.4.2 (Andreas, 01.12.2011):
 * LDAP client.
 *
 * 1.4.1 (Denis, 16.11.2011):
 * out.Logger: Don't use environment variable "LOGGER_HOME" any more, but the static method setConfigFile(String) to set the log4j config file.
 * build.xml: Rename project from DocuTools to Docutools.
 * Insert copyright message into all sources.
 *
 * 1.4.0 (Denis, 07.11.2011):
 * Changed the *interface* of class file.FileUtil: Introduce methods copyToOverwriting(...) and copyToMerging(...), remove method copyTo(...).
 *
 * 1.3.18 (Denis, 07.11.2011):
 * Correction in class file.FileUtil: copying a folder now overwrites any existing destination folder (before, it merged).
 *
 * 1.3.17 (Denis, 03.11.2011):
 * Correction in class file.MetadataProviderDROID: close file after getting the metadata, so no locks remain on this file.
 *
 * 1.3.16 (Denis, 02.11.2011):
 * Correction in class file.FileUtil: deleting and renaming a file are now retried 20 times, with 1/2 secs delay in-between.
 * Correction in class util.SystemProcess: cleanup all objects thoroughly after work is done. There are some weird problems with locked files under windows.
 *
 * 1.3.15 (Denis, 01.11.2011):
 * Added classes: FileChecksumCalculator, FileWithMetadata, MetadataProviderDROID, MetadataProviderJHOVE, MetadataFromJPGFile (moved from Docudarc to here)
 * Replaced required EnvironmentVariable "DOCUDARC_HOME" by "DOCUTOOLS_HOME". This is needed to locate the files DROID_SignatureFile_V52.xml and jhove.conf.
 *
 * 1.3.14 (Denis, 19.10.2011):
 * Added class: string.StringValueComparator, which compares string not lexographically but like integers, so that "10" > "9" is true.
 * Added class: util.Sound, which can play AIF files.
 *
 * 1.3.13 (Denis, 19.10.2011):
 * Modified class I18N: marked method get(String) as deprecated, use method translate(String) instead. Added method translate(String, Object...) for additional parameters.
 *
 * 1.3.12 (Denis, 10.10.2011):
 * Modified class MySQLJDBCConnection: added method getConnection(), and the create(...) methods now return the created connection.
 *
 * 1.3.11 (Denis, 20.09.2011):
 * Corrected method string.StringUtil.increment(String s): increment now 999 to 1000 instead of 9910.
 *
 * 1.3.10 (Denis, 19.09.2011):
 * Added no-argument methods trace(), debug(), info(), warn(), error(), and fatal() to class out.Logger.
 * Added method increment(String s) to class string.StringUtil.
 *
 * 1.3.9 (Denis, 12.09.2011):
 * Added method beep() to class OperatingSystem.
 * Added methods isNumeric(), isAlphaNumeric(), and isAlpha() to class StringUtil.
 *
 * 1.3.8 (Denis, 29.08.2011):
 * Added classes gui.LimitedTextField and gui.LimitedIntegerTextField.
 *
 * 1.3.7 (Denis, 26.08.2011):
 * Extended class StringUtil with the methods first(i), last(i), and splitQuoted(*).
 * Extended in class StringUtil the method split() with additional boolean parameter ignoreEmptyTokens, and added methods split(*) with default parameters.
 *
 * 1.3.6 (Denis, 28.07.2011):
 * Renamed folder config_gen to config_dist and adapted build.xml accordingly.
 * Extended class SystemOutView with a constructor where the header message can be specified.
 *
 * 1.3.5 (Denis, 26.07.2011):
 * Fixed a bug in class JTableWithDynamicToolTipTexts: a NullPointerException was thrown when the object returned as toolTipText was null.
 *
 * 1.3.4 (Andreas, 22.07.2011):
 * Updated truezip libraries to work with zip files >4GB
 *
 * 1.3.3 (Denis, 30.06.2011):
 * file.CSVFileReader: Modified so that the CSVFileReader can handle separators within quotes, and masked quotes
 *
 * 1.3.2 (Denis, 21.06.2011):
 * util.OperatingSystem: corrections.
 *
 * 1.3.1 (Denis, 20.06.2011):
 * Added class util.OperatingSystem.
 *
 * 1.3.0 (Denis, 17.06.2011):
 * Changed the *interface* of class util.SystemProcess so that VarArgs can be used (either execute(new String[]{"a", "b", "c"}) or (new) execute("a", "b", "c")).
 *
 * 1.2.15 (Denis, 16.06.2011):
 * Corrected class util.SystemProcess to be able to open under Windows files externally whose filename doesn't start with a drive identifier (like "C:").
 *
 * 1.2.14 (Denis, 15.06.2011):
 * Added class gui.JTableWithDynamicToolTipTexts, which is a subclass of JTable. It can be configured that for some columns, the cell content is displayed as the cell's toolTipText.
 * Extended class string.StringUtil with methods for trimming string (trimLeft, trimRight, trimLeftAndRight, trimMid, trimAll).
 * Cleanup: Corrected some code showing warnings.
 *
 * 1.2.13 (Andreas, 09.06.2011):
 * Use TrueZip (64Bit)
 *
 * 1.2.12 (Denis, 08.06.2011):
 * Extended class string.DateFormatter to format dates in 'long' format (java primitive numeric data structure containing the number of milliseconds since January 1, 1970, 00:00:00 GMT).
 * Extended class file.FileUtil with the method getFileContentAsString().
 *
 * 1.2.11 (Andreas, 08.06.2011):
 * Added timeout to file operations
 *
 * 1.2.10 (Denis, 30.05.2011):
 * Fixed bug in util.SystemProcess: Opening in windows a file whose address starts with "http://" now works.
 *
 * 1.2.9 (Denis, 23.05.2011):
 * Extended class string.StringUtil with the methods asFileNameWithoutExtension(...) and asFileNameExtension(...).
 *
 * 1.2.8 (Denis, 15.04.2011):
 * Extended class util.SystemProcess with the method openExternally(...).
 * Added class util.SystemProcessException.
 *
 * 1.2.7 (Denis, 08.04.2011):
 * Added class exceptions.FileIsNotADirectoryException, which gets thrown in util.SystemProcess.
 *
 * 1.2.6 (Denis, 06.04.2011):
 * Added class util.EnvironmentVariable.
 * Added class util.SystemProcess.
 *
 * 1.2.5 (Denis, 25.03.2011):
 * Added class file.FileFilter.AllFilesExceptHidden.
 *
 * 1.2.4 (Denis, 22.03.2011):
 * Added Log messages to file.FileUtil.
 *
 * 1.2.3 (Denis, 15.03.2011):
 * Extended class file.Zipper with the method zip(String sourcePath, String zipFilePath, boolean skipTopFolder) for zipping a folder excluding the top level folder.
 *
 * 1.2.2 (Denis, 15.03.2011):
 * Added abstract class string.StringUtil with many useful methods for Strings.
 *
 * 1.2.1 (Denis, 11.03.2011):
 * Improved util.Exception and util.ExceptionCollectorException to be better readable for the user.
 *
 */
public abstract class Version
{
	static public final String Product = "docuteam tools";
	static public final String Number = "1.10.6";
	static public final String LastChange = "31.03.2015";

	/**
	 * This main method is being used by the ant build script to be able to add a version number to the compiled jar file.
	 *
	 * @param args: No parameters are expected.
	 */
	public static void main(String[] args)
	{
		System.out.println(Number);
	}
}
