/**
 *	Copyright (C) 2011-2015 Docuteam GmbH
 *
 *	This program is free software: you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 3
 *	as published by the Free Software Foundation.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package ch.docuteam.darc.exceptions;

import ch.docuteam.darc.common.DocumentAbstract;

/**
 * This exception gets thrown when the attempt is made to make a modification to a SIP that would result in a file operation,
 * when this SIP was opened in a mode where file operations are prohibited.
 *
 * @author denis
 *
 */
public class FileOperationNotAllowedException extends Exception
{
	//	===========================================================================================
	//	========	Methods					=======================================================
	//	===========================================================================================

	//	========	Constructors Public		=======================================================

	public FileOperationNotAllowedException(DocumentAbstract document, String fileName, String fileOp)
	{
		super("File operation '" + fileOp + "' not allowed with '" + fileName + "' because SIP was opened without working copy: '" + document.getFilePath() + "'");
	}

}
