/**
 *	Copyright (C) 2011-2015 Docuteam GmbH
 *
 *	This program is free software: you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 3
 *	as published by the Free Software Foundation.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package ch.docuteam.darc.mdconfig;

import java.lang.reflect.InvocationTargetException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

import ch.docuteam.darc.exceptions.*;
import ch.docuteam.darc.mets.structmap.NodeAbstract;
import ch.docuteam.darc.mets.structmap.NodeFolder;

public class MetadataElementValidatorDateHierarchyYear implements MetadataElementValidator {

	@Override
	public void check(String value, NodeAbstract context, MetadataElement metadataElement) throws MetadataElementValidatorException {
		if (!context.isRoot()) {
			// TODO process also creationPeriod
			if (!(metadataElement.getAccessorName().startsWith("from") || metadataElement.getAccessorName().startsWith("to")))
				throw new MetadataElementValidatorException("cannot form a logic for this metadata element");

			try {
				Date parentValue = new SimpleDateFormat("yyyy").parse(((NodeFolder) context.getParent()).getDynamicMetadataValueForName(metadataElement.getAccessorName()));
				if (metadataElement.getAccessorName().startsWith("from"))
				{
					if (parentValue.after(new SimpleDateFormat("yyyy").parse(value)))
						throw new MetadataElementValidatorException("the value is chronologically before the parent's value");
				}
				else if (metadataElement.getAccessorName().startsWith("to")) {
					if (parentValue.before(new SimpleDateFormat("yyyy").parse(value)))
						throw new MetadataElementValidatorException("the value is chronologically after the parent's value");
				}
			} catch (ParseException e) {
				throw new MetadataElementValidatorException("parse error: could not parse the value '" + value + "' as a year ('yyyy')");
			} catch (IllegalArgumentException e) {
				e.printStackTrace();
				throw new MetadataElementValidatorException("error accessing the parent's metadata");
			} catch (IllegalAccessException e) {
				e.printStackTrace();
				throw new MetadataElementValidatorException("error accessing the parent's metadata");
			} catch (InvocationTargetException e) {
				e.printStackTrace();
				throw new MetadataElementValidatorException("error accessing the parent's metadata");
			} catch (MetadataElementIsNotAllowedException e) {
				e.printStackTrace();
				throw new MetadataElementValidatorException("error accessing the parent's metadata (element is not allowed)");
			} catch (MetadataElementIsNotDefinedException e) {
				e.printStackTrace();
				throw new MetadataElementValidatorException("error accessing the parent's metadata (element is not defined)");
			}
		}
	}

}
