/**
 *	Copyright (C) 2011-2015 Docuteam GmbH
 *
 *	This program is free software: you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 3
 *	as published by the Free Software Foundation.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package ch.docuteam.darc.premis;

import java.util.List;

import ch.docuteam.tools.string.StringSet;
import ch.docuteam.tools.string.StringSetElement;


/**
 * This class represents a PREMIS event outcome, one of "Success" or "Failure".
 *
 * @author denis
 *
 */
public class EventOutcome extends StringSetElement
{
	//	===========================================================================================
	//	========	Main					=======================================================
	//	===========================================================================================

	//	========	Static Initializer		=======================================================

	static
	{
		new EventOutcome("Success");
		new EventOutcome("Failure");
	}


	//	========	Constructors Private	=======================================================

	private EventOutcome(String value)
	{
		super(value);
	}


	//	========	Static Public			=======================================================

	static public EventOutcome get(String value)
	{
		EventOutcome outcome = (EventOutcome)StringSet.get(EventOutcome.class, value);
		if (outcome == null)
			outcome = new EventOutcome(value);
		return outcome;
	}


	static public List<? extends StringSetElement> getAll()
	{
		return StringSet.getAll(EventOutcome.class);
	}

}

