/**
 *	Copyright (C) 2011-2015 Docuteam GmbH
 *
 *	This program is free software: you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 3
 *	as published by the Free Software Foundation.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package ch.docuteam.darc.ead;

import java.util.Enumeration;

import org.dom4j.Element;
import org.jdesktop.swingx.treetable.MutableTreeTableNode;

import ch.docuteam.darc.mets.structmap.NodeAbstract;


/**
 * This class is structurally identical to <a href="./C.html">C</a> but it occurs only in the root level of an EAD element.
 *
 * @author denis
 *
 */
public class ArchDesc extends ComponentAbstract
{
	//	===========================================================================================
	//	========	Structure				=======================================================
	//	===========================================================================================

	//	========	Static Final Public		=======================================================

	//	========	Static Final Private	=======================================================

	//	========	Static Public			=======================================================

	//	========	Static Private			=======================================================

	//	========	Instance Public			=======================================================

	//	========	Instance Private		=======================================================

	//	===========================================================================================
	//	========	Main					=======================================================
	//	===========================================================================================

	//	===========================================================================================
	//	========	Methods					=======================================================
	//	===========================================================================================

	//	========	Static Initializer		=======================================================

	//	========	Constructors Public		=======================================================

	//	========	Constructors Private	=======================================================

	/**
	 * This constructor is used only when an EAD-File is being read.
	 */
	private ArchDesc(Document eadDocument, Element element)
	{
		super(eadDocument, element, 1);

		this.cs = C.parse(this, (Element)element.selectSingleNode("./EAD:dsc"), 2);
	}

	//	========	Static Public			=======================================================

	/**
	 * This method is used only when an EAD-File is being read.
	 */
	static public ArchDesc parse(Document eadDocument, Element parent)
	{
		return new ArchDesc(eadDocument, (Element)parent.selectSingleNode("./EAD:archdesc"));
	}

	//	========	Static Private			=======================================================

	//	========	Instance Public			=======================================================

	//	--------		Accessing			-------------------------------------------------------

	/**
	 * This method is called when an EAD-File is being created.
	 * Since the ArchDesc element already exists in the EAD template file, I mustn't create but just initialize it.
	 */
	public void initialize(String title)
	{
		this.did.setUnitTitle(title);
	}

	//	--------		Inquiring			-------------------------------------------------------
	//	--------		Interface			-------------------------------------------------------
	//	--------		Business Ops		-------------------------------------------------------
	//	--------		Persistence			-------------------------------------------------------
	//	--------		Support				-------------------------------------------------------
	//	--------		Utilities			-------------------------------------------------------
	//	---------		Misc				-------------------------------------------------------
	//	--------		Debugging			-------------------------------------------------------
	//	---------		Temporary			-------------------------------------------------------

	//	========	Instance Private		=======================================================

	//	--------		Initializing		-------------------------------------------------------
	//	--------		Accessing			-------------------------------------------------------
	//	--------		Inquiring			-------------------------------------------------------
	//	--------		Interface			-------------------------------------------------------

	/**
	 * This is done on EAD export.
	 */
	@Override
	public void fillEADElementsFromNodeRecursively(NodeAbstract node)
	{
		this.copyEADPropertiesFrom(node.getMyDMDSectionWithEAD().getC());

		//	Now do the same with all node's children recursively:
		for (Enumeration<? extends MutableTreeTableNode> e = node.children(); e.hasMoreElements();)
		{
			NodeAbstract child = (NodeAbstract)e.nextElement();

			//	First create dom4j element. Note that the dsc element already exists:
			Element cElement = ((Element)this.element.selectSingleNode("./EAD:dsc")).addElement("EAD:c");
			//	Then create new c element:
			C c = new C(this, cElement, child.getLabel());

			c.fillEADElementsFromNodeRecursively(child);				//	Recursion!
		}
	}

	//	--------		Business Ops		-------------------------------------------------------
	//	--------		Persistence			-------------------------------------------------------
	//	--------		Support				-------------------------------------------------------
	//	--------		Utilities			-------------------------------------------------------
	//	---------		Misc				-------------------------------------------------------
	//	--------		Debugging			-------------------------------------------------------

	@Override
	public String toString()
	{
		return super.toString("archdesc");
	}


	public String toStringShort()
	{
		return super.toStringShort("archdesc");
	}

	//	---------		Temporary			-------------------------------------------------------

	//	===========================================================================================
	//	========	Inner Classes			=======================================================
	//	===========================================================================================

}
