/**
 *	Copyright (C) 2011-2015 Docuteam GmbH
 *
 *	This program is free software: you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 3
 *	as published by the Free Software Foundation.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package ch.docuteam.darc.mdconfig;

import ch.docuteam.darc.exceptions.MetadataElementValidatorException;
import ch.docuteam.darc.mets.structmap.NodeAbstract;
import ch.docuteam.tools.string.StringUtil;
import ch.docuteam.tools.translations.I18N;


/**
 * A MetadataElementValidator that only accepts a positive short value between 0 and 32767.
 *
 * @author denis
 *
 */
public class MetadataElementValidatorShort implements MetadataElementValidator
{
	/* (non-Javadoc)
	 * @see ch.docuteam.darc.ead.DataElementValidator#check(java.lang.String, java.lang.Object)
	 */
	@Override
	public void check(String value, NodeAbstract context, MetadataElement metadataElement) throws MetadataElementValidatorException
	{
		if (!StringUtil.isNumeric(value))		throw new MetadataElementValidatorException(I18N.translate_NoCheck("MessageValidatorShortNotNumeric", value));
		if (value.length() > 5)					throw new MetadataElementValidatorException(I18N.translate_NoCheck("MessageValidatorShortMax5Digits", value));

		try
		{
			int number = new Integer(value);
			if (number > Short.MAX_VALUE)		throw new MetadataElementValidatorException(I18N.translate_NoCheck("MessageValidatorShortMaxValue", Short.MAX_VALUE, value));
		}
		catch (NumberFormatException ex)
		{
			throw new MetadataElementValidatorException(I18N.translate_NoCheck("MessageValidatorShortCantConvert", value));
		}
	}

}
