/**
 *	Copyright (C) 2011-2015 Docuteam GmbH
 *
 *	This program is free software: you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 3
 *	as published by the Free Software Foundation.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package ch.docuteam.darc.ead;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

import org.dom4j.Element;
import org.jdesktop.swingx.treetable.MutableTreeTableNode;

import ch.docuteam.darc.common.NodeAbstract;
import ch.docuteam.darc.mets.dmdsec.DMDSectionWithEAD;


/**
 * This class is structurally identical to <a href="./ArchDesc.html">ArchDesc</a>,
 * it occurs in <a href="./ArchDesc.html">ArchDesc</a> objects and recursively in other C elements.
 *
 * @author denis
 *
 */
public class C extends ComponentAbstract
{
	//	===========================================================================================
	//	========	Structure				=======================================================
	//	===========================================================================================

	//	========	Static Final Public		=======================================================

	//	========	Static Final Private	=======================================================

	//	========	Static Public			=======================================================

	//	========	Static Private			=======================================================

	//	========	Instance Public			=======================================================

	//	========	Instance Private		=======================================================

	//	===========================================================================================
	//	========	Main					=======================================================
	//	===========================================================================================

	//	===========================================================================================
	//	========	Methods					=======================================================
	//	===========================================================================================

	//	========	Static Initializer		=======================================================

	//	========	Constructors Public		=======================================================

	/**
	 * This constructor is used when a new C is created programmatically within a METS Document.
	 */
	public C(DMDSectionWithEAD parent, Element element, String title)
	{
		super(parent, element.addElement("EAD:c"), title);
	}

	//	========	Constructors Private	=======================================================

	/**
	 * This constructor is used when a new C is created programmatically within an EAD Document.
	 */
	protected C(ComponentAbstract parent, Element element, String title)
	{
		super(parent, element, title);

		parent.cs.add(this);
	}


	/**
	 * This constructor is used only when an EAD-File or METS-file is being read.
	 */
	private C(NodeAbstract parent, Element element, int depth)
	{
		super(parent, element, depth);
	}

	//	========	Static Public			=======================================================

	/**
	 * This method is used only when an EAD-File or METS-file is being read.
	 */
	static public List<C> parse(NodeAbstract parent, Element element, int depth)
	{
		List<C> cs = new ArrayList<C>();

		//	There might be no further c elements nested within this c element; in this case, return an empty collection:
		for (Object o: element.selectNodes("./EAD:c"))		cs.add(new C(parent, (Element)o, depth));

		return cs;
	}

	//	========	Static Private			=======================================================

	//	========	Instance Public			=======================================================

	//	--------		Accessing			-------------------------------------------------------
	//	--------		Inquiring			-------------------------------------------------------
	//	--------		Interface			-------------------------------------------------------

	/**
	 * This is done on EAD export.
	 */
	@Override
	public void fillEADElementsFromNodeRecursively(ch.docuteam.darc.mets.structmap.NodeAbstract node)
	{
		//	Set all my EAD properties from the node's c element:
		this.copyEADPropertiesFrom(node.getMyDMDSectionWithEAD().getC());

		//	Now do the same with all node's children recursively:
		for (Enumeration<? extends MutableTreeTableNode> e = node.children(); e.hasMoreElements();)
		{
			ch.docuteam.darc.mets.structmap.NodeAbstract child = (ch.docuteam.darc.mets.structmap.NodeAbstract)e.nextElement();

			//	First create dom4j element:
			Element cElement = this.element.addElement("EAD:c");
			//	Then create new c element:
			C c = new C(this, cElement, child.getLabel());

			c.fillEADElementsFromNodeRecursively(child);				//	Recursion!
		}
	}

	//	--------		Business Ops		-------------------------------------------------------
	//	--------		Persistence			-------------------------------------------------------
	//	--------		Support				-------------------------------------------------------
	//	--------		Utilities			-------------------------------------------------------
	//	---------		Misc				-------------------------------------------------------
	//	--------		Debugging			-------------------------------------------------------

	@Override
	public String toString()
	{
		return super.toString("c");
	}


	public String toStringShort()
	{
		return super.toStringShort("c");
	}

	//	---------		Temporary			-------------------------------------------------------

	//	========	Instance Private		=======================================================

	//	--------		Initializing		-------------------------------------------------------
	//	--------		Accessing			-------------------------------------------------------
	//	--------		Inquiring			-------------------------------------------------------
	//	--------		Interface			-------------------------------------------------------
	//	--------		Business Ops		-------------------------------------------------------
	//	--------		Persistence			-------------------------------------------------------
	//	--------		Support				-------------------------------------------------------
	//	--------		Utilities			-------------------------------------------------------
	//	---------		Misc				-------------------------------------------------------
	//	--------		Debugging			-------------------------------------------------------
	//	---------		Temporary			-------------------------------------------------------

	//	===========================================================================================
	//	========	Inner Classes			=======================================================
	//	===========================================================================================

}
