/**
 *	Copyright (C) 2011-2015 Docuteam GmbH
 *
 *	This program is free software: you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 3
 *	as published by the Free Software Foundation.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package ch.docuteam.darc.mdconfig;

import org.jdesktop.swingx.treetable.MutableTreeTableNode;

import ch.docuteam.darc.mets.structmap.NodeAbstract;
import ch.docuteam.darc.mets.structmap.NodeFolder;
import ch.docuteam.tools.string.StringUtil;

/**
 * Provides methods to customize defaultExpressions
 * Use by adding an attribute defaultExpression to a MetadataElement element in levels.xml like:
 * <code>defaultExpression="ch.docuteam.darc.mdconfig.MetadataElementDefaultExpressions.getUniqueNumericValueWithParentsPrefix( object1, object2 )"</code>
 * where object1 and object2 are arbitrary objects.
 * 
 * @author christian
 *
 */
public abstract class MetadataElementDefaultExpressions {
	//	===========================================================================================
	//	========	Structure				=======================================================
	//	===========================================================================================

	//	========	Static Final Public		=======================================================

	//	========	Static Final Private	=======================================================

	//	========	Static Public			=======================================================

	//	========	Static Private			=======================================================

	//	========	Instance Public			=======================================================

	//	========	Instance Private		=======================================================

	//	===========================================================================================
	//	========	Main					=======================================================
	//	===========================================================================================
	//	===========================================================================================
	//	========	Methods					=======================================================
	//	===========================================================================================

	//	========	Static Initializer		=======================================================

	//	========	Constructors Public		=======================================================

	//	========	Constructors Private	=======================================================

	//	========	Static Public			=======================================================

	//	--------		Initializing		-------------------------------------------------------
	//	--------		Accessing			-------------------------------------------------------
	//	--------		Inquiring			-------------------------------------------------------
	//	--------		Business Ops		-------------------------------------------------------
	//	--------		Persistence			-------------------------------------------------------
	//	--------		Support				-------------------------------------------------------
	//	--------		Utilities			-------------------------------------------------------
	//	---------		Misc				-------------------------------------------------------
	//	--------		Debugging			-------------------------------------------------------
	//	---------		Temporary			-------------------------------------------------------

	//	========	Static Private			=======================================================

	//	--------		Initializing		-------------------------------------------------------
	//	--------		Accessing			-------------------------------------------------------
	//	--------		Inquiring			-------------------------------------------------------
	//	--------		Business Ops		-------------------------------------------------------
	//	--------		Persistence			-------------------------------------------------------
	//	--------		Support				-------------------------------------------------------
	//	--------		Utilities			-------------------------------------------------------
	//	---------		Misc				-------------------------------------------------------
	//	--------		Debugging			-------------------------------------------------------
	//	---------		Temporary			-------------------------------------------------------

	//	========	Instance Public			=======================================================

	//	--------		Initializing		-------------------------------------------------------
	//	--------		Accessing			-------------------------------------------------------

	/**
	 * Calculate a unique value by prepending the parents value.
	 * Start with numbering if no siblings exist 
	 * Else take highest value among siblings and increment it
	 * 
	 * @param context the current NodeAbstract
	 * @param metadataElement the current MetadataElement
	 * @return computed unique value among siblings by using the parents element value and checking the siblings, computing a unique value
	 * @throws Exception
	 */
	public static String getUniqueNumericValueWithParentsPrefix(NodeAbstract context, MetadataElement metadataElement) throws Exception
	{
		String returnValue = null;
		if (context.isRoot())
		{
			//	start numbering in root node
			returnValue = "1";
		}
		else
		{
			//	get the parent node to obtain its value as prefix for the childrens values
			NodeFolder parent = (NodeFolder) context.getParent();
			String prefix = parent.getDynamicMetadataValueForName(metadataElement.getAccessorName()) + "/";
			for (MutableTreeTableNode child : ((NodeFolder)context.getParent()).getChildren())
			{
				//	Don't compare with itself:
				if (child == context)	continue;

				if (returnValue == null)
				{
					//	set value to current nodes value if not yet set
					returnValue = ((NodeAbstract)child).getDynamicMetadataValueForName(metadataElement.getAccessorName());
					
				}
				else
				{
					// get current childs value and compare with existing value in return value. Take the upper value
					String value = ((NodeAbstract)child).getDynamicMetadataValueForName(metadataElement.getAccessorName());
					int comparison = value.compareTo(returnValue);
					returnValue = comparison > 0 ? value : returnValue;
				}
			}
			if (returnValue == null)
			{
				//	value is not yet set, so start numbering with prefix
				returnValue = prefix + "1";
			}
			else
			{
				//	prepend prefix if not yet present and increment the value
				if (!returnValue.startsWith(prefix))
				{
					returnValue = prefix + returnValue;
				}
				returnValue = StringUtil.increment(returnValue);
			}
		}
		return returnValue;
	}
	
	//	--------		Inquiring			-------------------------------------------------------
	//	--------		Interface			-------------------------------------------------------
	//	--------		Actions				-------------------------------------------------------
	//	--------		Business Ops		-------------------------------------------------------
	//	--------		Persistence			-------------------------------------------------------
	//	--------		Support				-------------------------------------------------------
	//	--------		Utilities			-------------------------------------------------------
	//	---------		Misc				-------------------------------------------------------
	//	--------		Debugging			-------------------------------------------------------
	//	---------		Temporary			-------------------------------------------------------

	//	========	Instance Private		=======================================================

	//	--------		Initializing		-------------------------------------------------------
	//	--------		Accessing			-------------------------------------------------------
	//	--------		Inquiring			-------------------------------------------------------
	//	--------		Interface			-------------------------------------------------------
	//	--------		Actions				-------------------------------------------------------
	//	--------		Business Ops		-------------------------------------------------------
	//	--------		Persistence			-------------------------------------------------------
	//	--------		Support				-------------------------------------------------------
	//	--------		Utilities			-------------------------------------------------------
	//	---------		Misc				-------------------------------------------------------
	//	--------		Debugging			-------------------------------------------------------
	//	---------		Temporary			-------------------------------------------------------

	//	===========================================================================================
	//	========	Inner Classes			=======================================================
	//	===========================================================================================
}
