/**
 *	Copyright (C) 2014-2015 Docuteam GmbH
 *
 *	This program is free software: you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 3
 *	as published by the Free Software Foundation.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package ch.docuteam.darc.mdconfig;

import org.jdesktop.swingx.treetable.MutableTreeTableNode;

import ch.docuteam.darc.exceptions.MetadataElementValidatorException;
import ch.docuteam.darc.mets.structmap.NodeAbstract;
import ch.docuteam.darc.mets.structmap.NodeFolder;
import ch.docuteam.tools.translations.I18N;

/**
 * A MetadataElement validator that checks if value of an element is unique within the same level of the same subtree.
 *
 * @author christian
 *
 */
public class MetadataElementValidatorUniqueValueAmongSiblings implements MetadataElementValidator
{
	@Override
	public void check(String value, NodeAbstract context, MetadataElement metadataElement) throws MetadataElementValidatorException
	{
		//	Root has no siblings:
		if (context.isRoot())	return;

		String errorMessage = null;
		try
		{
			for (MutableTreeTableNode child: ((NodeFolder)context.getParent()).getChildren())
			{
				//	Don't compare with itself:
				if (child == context)	continue;

				if (((NodeAbstract)child).getAllDynamicMetadataValuesForName(metadataElement.getAccessorName()).contains(value))
				{
					errorMessage = I18N.translate_NoCheck("MessageValidatorUniqueValueAmongSiblings", value, I18N.translate_NoCheck(metadataElement.getId()));
					break;
				}
			}
		}
		catch (Exception ex)
		{
			ex.printStackTrace();
			errorMessage = ex.getMessage();
		}

		if (errorMessage != null)		throw new MetadataElementValidatorException(errorMessage);
	}

}
