/**
 *	Copyright (C) 2011-2015 Docuteam GmbH
 *
 *	This program is free software: you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 3
 *	as published by the Free Software Foundation.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package ch.docuteam.darc.mets.metshdr;

import java.util.ArrayList;
import java.util.List;

import org.dom4j.Element;

import ch.docuteam.darc.common.NodeAbstract;



/**
 * This class, used by the class <a href="./Header.html">Header</a>, represents the METS header agent.
 * It contains a role, a type, a name, and a note.
 *
 * @author denis
 *
 */
public class Agent extends NodeAbstract
{
	//	===========================================================================================
	//	========	Structure				=======================================================
	//	===========================================================================================

	//	========	Static Public			=======================================================

	//	========	Static Private			=======================================================

	//	========	Instance Public			=======================================================

	//	========	Instance Private		=======================================================

	protected String			role;
	protected String			type;
	protected String			name;
	protected String			note;

	//	===========================================================================================
	//	========	Methods					=======================================================
	//	===========================================================================================

	//	========	Static Initializer		=======================================================

	//	========	Constructors Public		=======================================================

	protected Agent() {}

	//	========	Constructors Private	=======================================================

	/**
	 * 	This constructor is used only when a METS-File is being read
	 */
	protected Agent(Header parent, Element element)
	{
		this.document = parent.getDocument();
		this.parent = parent;
		this.element = element;

		this.role = element.attributeValue("ROLE");
		this.type = element.attributeValue("TYPE");
		this.name = this.getElementText("./METS:name", false);
		this.note = this.getElementText("./METS:note", false);
	}

	//	========	Static Public			=======================================================

	/**
	 * This method is used only when a METS-File is being read. Create the list of HeaderAgents out of the given parent Header.
	 * @param parent The parent (a Header)
	 */
	static protected List<Agent> parse(Header parent)
	{
		List<Agent> agentList = new ArrayList<Agent>();

		for (Object o: parent.getElement().selectNodes("./METS:agent"))		agentList.add(new Agent(parent, (Element)o));

		return agentList;
	}

	//	========	Static Private			=======================================================

	//	========	Instance Public			=======================================================

	//	--------		Accessing			-------------------------------------------------------

	public String getRole()
	{
		return this.role;
	}

	public String getType()
	{
		return this.type;
	}

	public String getName()
	{
		return this.name;
	}

	public String getNote()
	{
		return this.note;
	}

	//	--------		Inquiring			-------------------------------------------------------
	//	--------		Interface			-------------------------------------------------------
	//	--------		Business Ops		-------------------------------------------------------
	//	--------		Persistence			-------------------------------------------------------
	//	--------		Support				-------------------------------------------------------
	//	--------		Utilities			-------------------------------------------------------
	//	--------		Debugging			-------------------------------------------------------
	//	---------		Temporary			-------------------------------------------------------

	//	========	Instance Private		=======================================================

	//	--------		Initializing		-------------------------------------------------------
	//	--------		Accessing			-------------------------------------------------------
	//	--------		Inquiring			-------------------------------------------------------
	//	--------		Business Ops		-------------------------------------------------------
	//	--------		Persistence			-------------------------------------------------------
	//	--------		Support				-------------------------------------------------------
	//	--------		Utilities			-------------------------------------------------------
	//	--------		Debugging			-------------------------------------------------------

	@Override
	public String toString()
	{
		return new StringBuilder("[Agent:")
			.append(this.name + "(")
			.append(this.role + "/")
			.append(this.type + ")]")
			.toString();
	}

	//	---------		Temporary			-------------------------------------------------------

	//	===========================================================================================
	//	========	Inner Classes			=======================================================
	//	===========================================================================================

}
