/**
 *	Copyright (C) 2011-2015 Docuteam GmbH
 *
 *	This program is free software: you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 3
 *	as published by the Free Software Foundation.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package ch.docuteam.converter.exceptions;

/**
 * This exception gets thrown after a file conversion, when the PRONOM id of the created file doesn't match the expected PRONOM id as specified in the <i>migration configuration file</i>.
 *
 * @author denis
 *
 */
public class BadPronomIdException extends Exception
{
	//	===========================================================================================
	//	========	Methods					=======================================================
	//	===========================================================================================

	//	========	Constructors Public		=======================================================

	public BadPronomIdException(String expectedPronomType, String currentPronomType)
	{
		super("Bad PRONOM id: expected=" + expectedPronomType + ", current=" + currentPronomType);
	}

}
