/**
 *	Copyright (C) 2011-2015 Docuteam GmbH
 *
 *	This program is free software: you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 3
 *	as published by the Free Software Foundation.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package ch.docuteam.converter.exceptions;

/**
 * This exception gets thrown when a file conversion fails.
 *
 * @author denis
 *
 */
public class FileConversionException extends Exception
{
	private Integer			failureCode = null;

	//	===========================================================================================
	//	========	Methods					=======================================================
	//	===========================================================================================

	//	========	Constructors Public		=======================================================

	public FileConversionException()
	{
		super("File conversion failed");
	}

	public FileConversionException(int failureCode)
	{
		super("File conversion failed with failure code=" + failureCode);

		this.failureCode = failureCode;
	}

	//	--------		Accessing			-------------------------------------------------------

	public Integer getFailureCode()
	{
		return this.failureCode;
	}

}
