/**
 *	Copyright (C) 2011-2015 Docuteam GmbH
 *
 *	This program is free software: you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 3
 *	as published by the Free Software Foundation.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package ch.docuteam.tools.gui;

import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

import ch.docuteam.tools.out.Logger;


/**
 * @author denis
 *
 */
public class JTableWithSpecificCellEditorPerRow extends JTableWithDynamicToolTipTexts
{
	//	===========================================================================================
	//	========	Structure				=======================================================
	//	===========================================================================================

	//	========	Static Final Public		=======================================================

	//	========	Static Final Private	=======================================================

	//	========	Static Public			=======================================================

	//	========	Static Private			=======================================================

	//	========	Instance Public			=======================================================

	//	========	Instance Private		=======================================================

	//	===========================================================================================
	//	========	Main					=======================================================
	//	===========================================================================================

	//	===========================================================================================
	//	========	Methods					=======================================================
	//	===========================================================================================

	//	========	Static Initializer		=======================================================

	//	========	Constructors Public		=======================================================

	public JTableWithSpecificCellEditorPerRow(TableModelWithSpecificCellEditorPerRow tableModel, int... toolTipTextColumnIndexes)
	{
		super(tableModel, toolTipTextColumnIndexes);
	}

	//	========	Constructors Private	=======================================================

	//	========	Static Public			=======================================================

	//	--------		Initializing		-------------------------------------------------------
	//	--------		Accessing			-------------------------------------------------------
	//	--------		Inquiring			-------------------------------------------------------
	//	--------		Business Ops		-------------------------------------------------------
	//	--------		Persistence			-------------------------------------------------------
	//	--------		Support				-------------------------------------------------------
	//	--------		Utilities			-------------------------------------------------------
	//	---------		Misc				-------------------------------------------------------
	//	--------		Debugging			-------------------------------------------------------
	//	---------		Temporary			-------------------------------------------------------

	//	========	Static Private			=======================================================

	//	--------		Initializing		-------------------------------------------------------
	//	--------		Accessing			-------------------------------------------------------
	//	--------		Inquiring			-------------------------------------------------------
	//	--------		Business Ops		-------------------------------------------------------
	//	--------		Persistence			-------------------------------------------------------
	//	--------		Support				-------------------------------------------------------
	//	--------		Utilities			-------------------------------------------------------
	//	---------		Misc				-------------------------------------------------------
	//	--------		Debugging			-------------------------------------------------------
	//	---------		Temporary			-------------------------------------------------------

	//	========	Instance Public			=======================================================

	//	--------		Initializing		-------------------------------------------------------
	//	--------		Accessing			-------------------------------------------------------
	//	--------		Inquiring			-------------------------------------------------------
	//	--------		Interface			-------------------------------------------------------

	/**
	 * Retrieve the appropriate cell editor for this row and column from the table model used.
	 */
	@Override
	public TableCellEditor getCellEditor(int row, int col)
	{
		TableCellEditor specificCellEditor = ((TableModelWithSpecificCellEditorPerRow)this.getModel()).getCellEditor(row, col);
		if (specificCellEditor != null)		return specificCellEditor;

		return super.getCellEditor(row, col);
	}

	/**
	 * Retrieve the appropriate cell renderer for this row and column from the table model used.
	 */
	@Override
	public TableCellRenderer getCellRenderer(int row, int col)
	{
		TableCellRenderer specificCellRenderer = ((TableModelWithSpecificCellEditorPerRow)this.getModel()).getCellRenderer(row, col);
		if (specificCellRenderer != null)		return specificCellRenderer;

		return super.getCellRenderer(row, col);
	}

	//	--------		Actions				-------------------------------------------------------

	/**
	 * Commit (or cancel if commit fails) current cell editor.
	 * Note that this method does NOT support a veto.
	 * @return
	 */
	public void commitOrCancelCurrentCellEditor()
	{
		if (this.cellEditor == null)	return;

		if (this.cellEditor.stopCellEditing())
		{
			Logger.getLogger().debug("Cell editing committed");
		}
		else
		{
			this.cellEditor.cancelCellEditing();
			Logger.getLogger().debug("Cell editing cancelled");
		}
	}

	//	--------		Business Ops		-------------------------------------------------------
	//	--------		Persistence			-------------------------------------------------------
	//	--------		Support				-------------------------------------------------------
	//	--------		Utilities			-------------------------------------------------------
	//	---------		Misc				-------------------------------------------------------
	//	--------		Debugging			-------------------------------------------------------
	//	---------		Temporary			-------------------------------------------------------

	//	========	Instance Private		=======================================================

	//	--------		Initializing		-------------------------------------------------------
	//	--------		Accessing			-------------------------------------------------------
	//	--------		Inquiring			-------------------------------------------------------
	//	--------		Interface			-------------------------------------------------------
	//	--------		Actions				-------------------------------------------------------
	//	--------		Business Ops		-------------------------------------------------------
	//	--------		Persistence			-------------------------------------------------------
	//	--------		Support				-------------------------------------------------------
	//	--------		Utilities			-------------------------------------------------------
	//	---------		Misc				-------------------------------------------------------
	//	--------		Debugging			-------------------------------------------------------
	//	---------		Temporary			-------------------------------------------------------

	//	===========================================================================================
	//	========	Inner Classes			=======================================================
	//	===========================================================================================

}
