/**
 *	Copyright (C) 2011-2015 Docuteam GmbH
 *
 *	This program is free software: you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 3
 *	as published by the Free Software Foundation.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package ch.docuteam.tools.gui;

import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import java.util.Observer;

import javax.swing.*;

/**
 * @author denis
 *
 * The SmallPeskyProgressBarWindow is a window that can not be closed or moved by the user (that's why it's called pesky).
 * The only way to remove it is to close the parent window or quit the application. Or programatically, to send "close()" to the window.
 *
 * Opening and closing an instance of SmallPeskyProgressBarWindow has to happen within an instance of SwingWorker,
 * otherwise it will not be rendered correctly and remains empty.
 *
 * Example:
 * <code>
				new SwingWorker<Integer, Object>()
				{
					@Override public Integer doInBackground()
					{
						SmallPeskyProgressBarWindow w = SmallPeskyProgressBarWindow.open(f, 3);
						try
						{
							Thread.sleep(1000);
							w.nextValue();
							Thread.sleep(1000);
							w.nextValue();
							Thread.sleep(1000);
							w.nextValue();
							Thread.sleep(1000);
							w.nextValue();
							Thread.sleep(1000);
							w.nextValue();
							Thread.sleep(1000);
						}
						catch (InterruptedException ex){}
						w.close();

						return 0;
					}
				}.execute();
 * </code>
 */
public class SmallPeskyProgressBarWindow extends JDialog implements Observer
{
	//	===========================================================================================
	//	========	Structure				=======================================================
	//	===========================================================================================

	//	========	Static Final Public		=======================================================

	//	========	Static Final Private	=======================================================

	//	========	Static Public			=======================================================

	//	========	Static Private			=======================================================

	//	========	Instance Public			=======================================================

	//	========	Instance Private		=======================================================

	private JProgressBar		progressBar;

	private boolean				isBlocking = false;

	//	===========================================================================================
	//	========	Main					=======================================================
	//	===========================================================================================

	/**
	 * @param args
	 */
	public static void main(String[] args)
	{
		final JFrame f = new JFrame();
		f.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		JButton b = new JButton();
		b.addActionListener(new ActionListener()
		{ @Override public void actionPerformed(ActionEvent e)
		{
			new SwingWorker<Integer, Object>()
			{
				@Override public Integer doInBackground()
				{
//					SmallPeskyProgressBarWindow w = SmallPeskyProgressBarWindow.open(f, 3);
					SmallPeskyProgressBarWindow w = SmallPeskyProgressBarWindow.openBlocking(f, 3);
					try
					{
						Thread.sleep(1000);
						w.nextValue();
						Thread.sleep(1000);
						w.nextValue();
						Thread.sleep(1000);
						w.nextValue();
						Thread.sleep(1000);
						w.nextValue();
						Thread.sleep(1000);
						w.nextValue();
						Thread.sleep(1000);
					}
					catch (InterruptedException ex){}
					w.close();

					return 0;
				}
			}.execute();
		}
		});
		f.add(b);
		f.setSize(400, 200);
		f.setLocationRelativeTo(null);
		f.setVisible(true);
	}

	//	===========================================================================================
	//	========	Methods					=======================================================
	//	===========================================================================================

	//	========	Static Initializer		=======================================================

	//	========	Constructors Public		=======================================================

	//	========	Constructors Private	=======================================================

	private SmallPeskyProgressBarWindow(Window parent, int maximum, boolean isBlocking)
	{
		super(parent);

		this.isBlocking = isBlocking;
		if (this.isBlocking && parent != null)		parent.setEnabled(false);

		this.setUndecorated(true);
		this.progressBar = new JProgressBar(0, maximum);
		this.progressBar.setValue(0);
		this.progressBar.setStringPainted(true);

		JPanel p = new JPanel(new BorderLayout());
		p.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 20));
		p.add(this.progressBar, BorderLayout.CENTER);

		this.add(p);
		this.setSize(300, 100);
		this.setLocationRelativeTo(parent);
	}

	//	========	Static Public			=======================================================

	//	--------		Initializing		-------------------------------------------------------

	static public SmallPeskyProgressBarWindow open(Window parent, int max)
	{
		SmallPeskyProgressBarWindow w = new SmallPeskyProgressBarWindow(parent, max, false);
		w.setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
		w.setVisible(true);
		return w;
	}

	static public SmallPeskyProgressBarWindow openBlocking(Window parent, int max)
	{
		SmallPeskyProgressBarWindow w = new SmallPeskyProgressBarWindow(parent, max, true);
		w.setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
		w.setVisible(true);
		return w;
	}

	//	--------		Accessing			-------------------------------------------------------
	//	--------		Inquiring			-------------------------------------------------------
	//	--------		Business Ops		-------------------------------------------------------
	//	--------		Persistence			-------------------------------------------------------
	//	--------		Support				-------------------------------------------------------
	//	--------		Utilities			-------------------------------------------------------
	//	---------		Misc				-------------------------------------------------------
	//	--------		Debugging			-------------------------------------------------------
	//	---------		Temporary			-------------------------------------------------------

	//	========	Static Private			=======================================================

	//	--------		Initializing		-------------------------------------------------------
	//	--------		Accessing			-------------------------------------------------------
	//	--------		Inquiring			-------------------------------------------------------
	//	--------		Business Ops		-------------------------------------------------------
	//	--------		Persistence			-------------------------------------------------------
	//	--------		Support				-------------------------------------------------------
	//	--------		Utilities			-------------------------------------------------------
	//	---------		Misc				-------------------------------------------------------
	//	--------		Debugging			-------------------------------------------------------
	//	---------		Temporary			-------------------------------------------------------

	//	========	Instance Public			=======================================================

	//	--------		Initializing		-------------------------------------------------------
	//	--------		Accessing			-------------------------------------------------------

	public void setValue(int value)
	{
		this.progressBar.setValue(value);
	}

	public void nextValue()
	{
		this.progressBar.setValue(this.progressBar.getValue() + 1);
	}

	public void close()
	{
		this.setCursor(Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));
		this.setVisible(false);
		this.dispose();

		if (this.isBlocking && this.getParent() != null)		this.getParent().setEnabled(true);
	}

	//	--------		Inquiring			-------------------------------------------------------
	//	--------		Interface			-------------------------------------------------------

	/* (non-Javadoc)
	 * @see java.util.Observer#update(java.util.Observable, java.lang.Object)
	 */
	@Override
	public void update(Observable obs, Object obj)
	{
		try
		{
			this.setValue((Integer)obj);
		}
		catch(ClassCastException ex) {}			//	Ignore if object can't be cast to Integer
	}

	//	--------		Actions				-------------------------------------------------------
	//	--------		Business Ops		-------------------------------------------------------
	//	--------		Persistence			-------------------------------------------------------
	//	--------		Support				-------------------------------------------------------
	//	--------		Utilities			-------------------------------------------------------
	//	---------		Misc				-------------------------------------------------------
	//	--------		Debugging			-------------------------------------------------------
	//	---------		Temporary			-------------------------------------------------------

	//	========	Instance Private		=======================================================

	//	--------		Initializing		-------------------------------------------------------
	//	--------		Accessing			-------------------------------------------------------
	//	--------		Inquiring			-------------------------------------------------------
	//	--------		Interface			-------------------------------------------------------
	//	--------		Actions				-------------------------------------------------------
	//	--------		Business Ops		-------------------------------------------------------
	//	--------		Persistence			-------------------------------------------------------
	//	--------		Support				-------------------------------------------------------
	//	--------		Utilities			-------------------------------------------------------
	//	---------		Misc				-------------------------------------------------------
	//	--------		Debugging			-------------------------------------------------------
	//	---------		Temporary			-------------------------------------------------------

	//	===========================================================================================
	//	========	Inner Classes			=======================================================
	//	===========================================================================================

}
