/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.core.signature.droid6;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import uk.gov.nationalarchives.droid.core.signature.ByteReader;
import uk.gov.nationalarchives.droid.core.signature.FileFormat;
import uk.gov.nationalarchives.droid.core.signature.droid6.ByteSequence;
import uk.gov.nationalarchives.droid.core.signature.droid6.ByteSequenceComparator;
import uk.gov.nationalarchives.droid.core.signature.xml.SimpleElement;

public class InternalSignature
extends SimpleElement {
    private static final int BIT1 = 1;
    private static final int BIT2 = 2;
    private static final int BIT3 = 4;
    private static final int BIT4 = 8;
    private static final int BIT5 = 16;
    private static final String SPACE = " ";
    private List<ByteSequence> byteSequences = new ArrayList<ByteSequence>();
    private int intSigID;
    private boolean specificity;
    private final List<FileFormat> fileFormatList = new ArrayList<FileFormat>();
    private int sortOrder;
    private boolean isInvalidSignature;

    public final void addByteSequence(ByteSequence byteSequence) {
        this.byteSequences.add(byteSequence);
    }

    public final int getSortOrder() {
        return this.sortOrder;
    }

    public final void prepareForUse() {
        this.isInvalidSignature = this.prepareByteSequences();
    }

    public boolean isInvalidSignature() {
        return this.isInvalidSignature;
    }

    private String getFileFormatPUIDs() {
        StringBuffer formats = new StringBuffer();
        int endOfFileFormats = this.fileFormatList.size();
        for (int fileFormatIndex = 0; fileFormatIndex < endOfFileFormats; ++fileFormatIndex) {
            FileFormat format = this.fileFormatList.get(fileFormatIndex);
            if (fileFormatIndex > 0) {
                formats.append(SPACE);
            }
            formats.append(format.getPUID());
        }
        return formats.toString();
    }

    private String getFileFormatNames() {
        StringBuffer formats = new StringBuffer();
        int endOfFileFormats = this.fileFormatList.size();
        for (int fileFormatIndex = 0; fileFormatIndex < endOfFileFormats; ++fileFormatIndex) {
            FileFormat format = this.fileFormatList.get(fileFormatIndex);
            if (fileFormatIndex > 0) {
                formats.append(SPACE);
            }
            formats.append(format.getName());
        }
        return formats.toString();
    }

    private boolean prepareByteSequences() {
        int endIndex = this.byteSequences.size();
        boolean hasOnlyVarSequences = true;
        for (int byteSequenceIndex = 0; byteSequenceIndex < endIndex; ++byteSequenceIndex) {
            ByteSequence byteSequence = this.byteSequences.get(byteSequenceIndex);
            byteSequence.prepareForUse();
            if (byteSequence.isInvalidByteSequence()) {
                return true;
            }
            if (!byteSequence.isAnchoredToBOF() && !byteSequence.isAnchoredToEOF()) continue;
            hasOnlyVarSequences = false;
        }
        if (hasOnlyVarSequences) {
            this.getLog().warn((Object)this.getPerformanceWarningMessage());
        }
        this.reorderByteSequences();
        this.calculateSignatureSortOrder();
        return false;
    }

    private String getPerformanceWarningMessage() {
        return String.format("Signature [id:%d] will always scan up to maximum bytes.  Matches formats: %s", this.intSigID, this.getFileFormatDescriptions());
    }

    public String getFileFormatDescriptions() {
        StringBuilder builder = new StringBuilder();
        for (FileFormat format : this.fileFormatList) {
            String formatInfo = String.format(" [Name:%s] [PUID:%s]  ", format.getName(), format.getPUID());
            builder.append(formatInfo);
        }
        return builder.toString();
    }

    private void reorderByteSequences() {
        Collections.sort(this.byteSequences, new ByteSequenceComparator());
    }

    private void calculateSignatureSortOrder() {
        int sortBits = 0;
        List<ByteSequence> sequences = this.byteSequences;
        int noOfSequences = sequences.size();
        for (int byteSequenceIndex = 0; byteSequenceIndex < noOfSequences; ++byteSequenceIndex) {
            ByteSequence seq = sequences.get(byteSequenceIndex);
            if (seq.isAnchoredToBOF()) {
                if (seq.getNumberOfSubSequences() == 1) {
                    sortBits |= 1;
                    continue;
                }
                sortBits |= 2;
                continue;
            }
            if (seq.isAnchoredToEOF()) {
                if (seq.getNumberOfSubSequences() == 1) {
                    sortBits |= 8;
                    continue;
                }
                sortBits |= 0x10;
                continue;
            }
            sortBits |= 4;
        }
        this.sortOrder = sortBits;
    }

    public final void addFileFormat(FileFormat theFileFormat) {
        this.fileFormatList.add(theFileFormat);
    }

    public final void removeFileFormat(FileFormat format) {
        this.fileFormatList.remove(format);
    }

    public final void setID(String theIntSigID) {
        this.intSigID = Integer.parseInt(theIntSigID);
    }

    @Deprecated
    public final void setSpecificity(String specificity) {
        this.specificity = "specific".equalsIgnoreCase(specificity);
    }

    @Override
    public final void setAttributeValue(String name, String value) {
        if ("ID".equals(name)) {
            this.setID(value);
        } else if ("Specificity".equals(name)) {
            this.setSpecificity(value);
        } else {
            this.unknownAttributeWarning(name, this.getElementName());
        }
    }

    public final List<ByteSequence> getByteSequences() {
        return this.byteSequences;
    }

    public final int getNumFileFormats() {
        return this.fileFormatList.size();
    }

    public final FileFormat getFileFormat(int theIndex) {
        return this.fileFormatList.get(theIndex);
    }

    public final int getID() {
        return this.intSigID;
    }

    @Deprecated
    public final boolean isSpecific() {
        return this.specificity;
    }

    public final boolean matches(ByteReader targetFile, long maxBytesToScan) {
        boolean matchResult = true;
        List<ByteSequence> sequences = this.byteSequences;
        int numseqs = sequences.size();
        for (int sequenceIndex = 0; matchResult && sequenceIndex < numseqs; ++sequenceIndex) {
            matchResult = sequences.get(sequenceIndex).matches(targetFile, maxBytesToScan);
        }
        return matchResult;
    }

    public final String toString() {
        return this.intSigID + "(" + this.specificity + ")" + this.byteSequences;
    }

    public List<String> toRegularExpressions() {
        ArrayList<String> regularExpressions = new ArrayList<String>();
        List<ByteSequence> sequences = this.byteSequences;
        int numseqs = sequences.size();
        for (int sequenceIndex = 0; sequenceIndex < numseqs; ++sequenceIndex) {
            ByteSequence sequence = sequences.get(sequenceIndex);
            String reference = sequence.getReference();
            String expression = sequence.toRegularExpression(false);
            String pretty = sequence.toRegularExpression(true);
            String row = String.format("%s\t%s\t%s", reference, pretty, expression);
            regularExpressions.add(row);
        }
        return regularExpressions;
    }

    public final void debugWriteOutSignatureSequences(Writer writer) {
        List<String> regExes = this.toRegularExpressions();
        String formats = this.getFileFormatPUIDs();
        String formatNames = this.getFileFormatNames();
        String prefix = String.format("%d\t%s\t%s\t", this.intSigID, formats, formatNames);
        for (int listIndex = 0; listIndex < regExes.size(); ++listIndex) {
            String output = prefix + regExes.get(listIndex);
            try {
                writer.write(output + "\n");
                continue;
            }
            catch (IOException ex) {
                this.getLog().error((Object)ex.getMessage());
            }
        }
    }
}

