/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.rof;

import de.schlichtherle.truezip.rof.ReadOnlyFile;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ReadOnlyFileInputStream
extends InputStream {
    protected ReadOnlyFile rof;
    private long mark = -1L;

    public ReadOnlyFileInputStream(ReadOnlyFile rof) {
        this.rof = rof;
    }

    @Override
    public int read() throws IOException {
        return this.rof.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.rof.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.rof.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        if (n <= 0L) {
            return 0L;
        }
        long fp = this.rof.getFilePointer();
        long len = this.rof.length();
        long rem = len - fp;
        if (n > rem) {
            n = (int)rem;
        }
        this.rof.seek(fp + n);
        return n;
    }

    @Override
    public int available() throws IOException {
        long rem = this.rof.length() - this.rof.getFilePointer();
        return rem > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)rem;
    }

    @Override
    public void close() throws IOException {
        this.rof.close();
    }

    @Override
    public void mark(int readlimit) {
        try {
            this.mark = this.rof.getFilePointer();
        }
        catch (IOException ex) {
            Logger.getLogger(ReadOnlyFileInputStream.class.getName()).log(Level.WARNING, ex.getLocalizedMessage(), ex);
            this.mark = -2L;
        }
    }

    @Override
    public void reset() throws IOException {
        if (this.mark < 0L) {
            throw new IOException(this.mark == -1L ? "no mark set" : "mark()/reset() not supported by underlying file");
        }
        this.rof.seek(this.mark);
    }

    @Override
    public boolean markSupported() {
        try {
            this.rof.seek(this.rof.getFilePointer());
            return true;
        }
        catch (IOException failure) {
            return false;
        }
    }
}

