/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.tiff;

import edu.harvard.hul.ois.jhove.NisoImageMetadata;
import edu.harvard.hul.ois.jhove.module.tiff.IFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffFXBase;
import edu.harvard.hul.ois.jhove.module.tiff.TiffIFD;

public class TiffProfileFXS
extends TiffFXBase {
    public TiffProfileFXS() {
        this._profileText = "TIFF-FX (Profile S)";
        this._mimeClass = 1;
    }

    public boolean satisfiesThisProfile(IFD iFD) {
        if (!(iFD instanceof TiffIFD)) {
            return false;
        }
        TiffIFD tiffIFD = (TiffIFD)iFD;
        if (!this.satisfiesClass(tiffIFD)) {
            return false;
        }
        if (iFD.isBigEndian()) {
            return false;
        }
        NisoImageMetadata nisoImageMetadata = tiffIFD.getNisoImageMetadata();
        int[] nArray = nisoImageMetadata.getBitsPerSample();
        if (nArray[0] != 1) {
            return false;
        }
        if (nisoImageMetadata.getStripOffsets().length > 1) {
            return false;
        }
        int n = nisoImageMetadata.getSamplingFrequencyUnit();
        if (n != 2 && n != -1) {
            return false;
        }
        if (nisoImageMetadata.getCompressionScheme() != 3) {
            return false;
        }
        if (tiffIFD.getFillOrder() != 2) {
            return false;
        }
        if (nisoImageMetadata.getImageWidth() != 1728L) {
            return false;
        }
        if (nisoImageMetadata.getSamplesPerPixel() != 1) {
            return false;
        }
        long l = nisoImageMetadata.getXSamplingFrequency().toLong();
        long l2 = nisoImageMetadata.getYSamplingFrequency().toLong();
        if (l != 200L && l != 204L) {
            return false;
        }
        if (l2 != 98L && l2 != 100L && l2 != 196L && l2 != 200L) {
            return false;
        }
        long l3 = tiffIFD.getT4Options();
        return (l3 & 3L) == 0L;
    }
}

