/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.core.interfaces.config;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;

public final class RuntimeConfig {
    public static final String DROID_USER = "droidUserDir";
    public static final String DROID_TEMP_DIR = "droidTempDir";
    public static final String LOG_DIR = "droidLogDir";
    public static final String DEFAULT_LOGFOLDER_NAME = "logs";
    public static final String DEFAULT_DROIDFOLDER_NAME = ".droid6";
    private static final String LOG4J_PROPERTIES = "log4j.properties";
    private static final String CONSOLE_LOG_THRESHOLD = "consoleLogThreshold";
    private static final String LOG4J_CONFIGURATION = "log4j.configuration";
    private static final String ERROR_CREATING_LOG4J_FILE = "Could not create the default log4j property file [%s] at: %s";

    private RuntimeConfig() {
    }

    public static void configureRuntimeEnvironment() {
        File logConfigFile;
        File defaultDroidWorkingFolder = new File(System.getProperty("user.home"), DEFAULT_DROIDFOLDER_NAME);
        File droidWorkDir = RuntimeConfig.createFolderAndSystemProperty(DROID_USER, defaultDroidWorkingFolder);
        File droidTempDir = RuntimeConfig.createFolderAndSystemProperty(DROID_TEMP_DIR, defaultDroidWorkingFolder);
        File defaultDroidLogFolder = new File(droidWorkDir, DEFAULT_LOGFOLDER_NAME);
        File logDir = RuntimeConfig.createFolderAndSystemProperty(LOG_DIR, defaultDroidLogFolder);
        File logFile = new File(logDir, "droid.log");
        System.setProperty("logFile", logFile.getPath());
        String logConfig = RuntimeConfig.getSystemOrEnvironmentProperty(LOG4J_CONFIGURATION);
        if (logConfig == null) {
            try {
                logConfigFile = RuntimeConfig.createResourceFile(droidWorkDir, LOG4J_PROPERTIES, LOG4J_PROPERTIES);
                String logFileURI = logConfigFile.toURI().toString();
                System.setProperty(LOG4J_CONFIGURATION, logFileURI);
            }
            catch (Exception e) {
                String message = String.format(ERROR_CREATING_LOG4J_FILE, LOG4J_PROPERTIES, droidWorkDir.getAbsolutePath());
                throw new RuntimeException(message, e);
            }
        } else {
            logConfigFile = new File(logConfig);
            String logFileURI = logConfigFile.toURI().toString();
            System.setProperty(LOG4J_CONFIGURATION, logFileURI);
        }
        String consoleLogThreshold = RuntimeConfig.getSystemOrEnvironmentProperty(CONSOLE_LOG_THRESHOLD);
        if (consoleLogThreshold == null || consoleLogThreshold.isEmpty()) {
            System.setProperty(CONSOLE_LOG_THRESHOLD, "INFO");
        }
    }

    private static File createFolderAndSystemProperty(String property, File defaultFolder) {
        String folderPath = RuntimeConfig.getSystemOrEnvironmentProperty(property);
        File folder = folderPath == null || folderPath.isEmpty() ? defaultFolder : new File(folderPath);
        folder.mkdirs();
        System.setProperty(property, folder.getPath());
        return folder;
    }

    private static String getSystemOrEnvironmentProperty(String property) {
        String value = System.getProperty(property);
        if (value == null) {
            value = System.getenv(property);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File createResourceFile(File resourceDir, String fileName, String resourceName) throws IOException {
        File resourceFile = null;
        InputStream in = RuntimeConfig.class.getClassLoader().getResourceAsStream(resourceName);
        if (in != null && (resourceFile = new File(resourceDir, fileName)).createNewFile()) {
            FileOutputStream out = new FileOutputStream(resourceFile);
            try {
                IOUtils.copy((InputStream)in, (OutputStream)out);
            }
            finally {
                if (out != null) {
                    ((OutputStream)out).close();
                }
                if (in != null) {
                    in.close();
                }
            }
        }
        return resourceFile;
    }
}

