/*
 * Decompiled with CFR 0.152.
 */
package net.domesdaybook.automata.nfa;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.domesdaybook.automata.Transition;
import net.domesdaybook.automata.nfa.NfaState;
import net.domesdaybook.automata.nfa.NfaTransitions;
import net.domesdaybook.automata.nfa.NfaTransitionsList;
import net.domesdaybook.automata.nfa.NfaTransitionsSingle;
import net.domesdaybook.object.copy.DeepCopy;

public class NfaSimpleState
implements NfaState {
    private NfaTransitions transitions;
    private boolean isFinal;
    private String label;

    public NfaSimpleState(String label, boolean isFinal) {
        this.label = label;
        this.isFinal = isFinal;
        this.transitions = new NfaTransitionsList();
    }

    public NfaSimpleState(NfaSimpleState other) {
        this.label = other.label;
        this.isFinal = other.isFinal;
        this.transitions = other.transitions;
    }

    public NfaSimpleState() {
        this("", false);
    }

    public NfaSimpleState(String label) {
        this(label, false);
    }

    public NfaSimpleState(boolean isFinal) {
        this("", isFinal);
    }

    @Override
    public final void addTransition(Transition transition) {
        if (this.transitions.size() == 0) {
            this.transitions = new NfaTransitionsSingle(transition);
        } else {
            if (this.transitions.size() == 1) {
                this.transitions = new NfaTransitionsList(this.transitions.getTransitions());
            }
            this.transitions.addTransition(transition);
        }
    }

    @Override
    public final void addAllTransitions(List<Transition> transitions) {
        for (Transition transition : transitions) {
            this.addTransition(transition);
        }
    }

    @Override
    public final Set<NfaState> nextStates(byte theByte) {
        return this.transitions.getStatesForByte(theByte);
    }

    @Override
    public final boolean isFinal() {
        return this.isFinal;
    }

    @Override
    public void setIsFinal(boolean isFinal) {
        this.isFinal = isFinal;
    }

    @Override
    public final String getLabel() {
        return this.label;
    }

    @Override
    public List<Transition> getTransitions() {
        return this.transitions.getTransitions();
    }

    @Override
    public NfaSimpleState deepCopy() {
        HashMap oldToNewObjects = new HashMap();
        return this.deepCopy((Map)oldToNewObjects);
    }

    @Override
    public NfaSimpleState deepCopy(Map<DeepCopy, DeepCopy> oldToNewObjects) {
        NfaSimpleState copy = (NfaSimpleState)oldToNewObjects.get(this);
        if (copy == null) {
            copy = new NfaSimpleState(this);
            oldToNewObjects.put(this, copy);
            copy.transitions = copy.transitions.deepCopy(oldToNewObjects);
        }
        return copy;
    }

    @Override
    public final void setLabel(String label) {
        this.label = label;
    }
}

