/*
 * Decompiled with CFR 0.152.
 */
package net.domesdaybook.matcher.singlebyte;

import net.domesdaybook.matcher.singlebyte.ByteUtilities;
import net.domesdaybook.matcher.singlebyte.SingleByteMatcher;
import net.domesdaybook.reader.ByteReader;

public final class ByteMatcher
implements SingleByteMatcher {
    private final byte byteToMatch;

    public ByteMatcher(byte byteToMatch) {
        this.byteToMatch = byteToMatch;
    }

    @Override
    public final boolean matches(ByteReader reader, long matchFrom) {
        return this.matches(reader.readByte(matchFrom));
    }

    @Override
    public final boolean matches(byte theByte) {
        return theByte == this.byteToMatch;
    }

    @Override
    public final byte[] getMatchingBytes() {
        return new byte[]{this.byteToMatch};
    }

    @Override
    public final String toRegularExpression(boolean prettyPrint) {
        String regex = ByteUtilities.byteToString(prettyPrint, this.byteToMatch & 0xFF);
        return prettyPrint ? regex + " " : regex;
    }

    @Override
    public final int getNumberOfMatchingBytes() {
        return 1;
    }
}

