/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.command.action;

import java.io.PrintWriter;
import java.util.Map;
import uk.gov.nationalarchives.droid.command.action.CommandExecutionException;
import uk.gov.nationalarchives.droid.command.action.DroidCommand;
import uk.gov.nationalarchives.droid.command.i18n.I18N;
import uk.gov.nationalarchives.droid.core.interfaces.signature.SignatureFileInfo;
import uk.gov.nationalarchives.droid.core.interfaces.signature.SignatureManager;
import uk.gov.nationalarchives.droid.core.interfaces.signature.SignatureManagerException;
import uk.gov.nationalarchives.droid.core.interfaces.signature.SignatureType;

public class DownloadSignatureUpdateCommand
implements DroidCommand {
    private SignatureManager signatureManager;
    private PrintWriter printWriter;

    @Override
    public void execute() throws CommandExecutionException {
        try {
            Map<SignatureType, SignatureFileInfo> signatureFileInfos = this.signatureManager.getLatestSignatureFiles();
            if (signatureFileInfos.isEmpty()) {
                this.printWriter.println(I18N.getResource("signature_update.check.unavailable"));
            } else {
                for (SignatureFileInfo sigFileInfo : signatureFileInfos.values()) {
                    this.signatureManager.downloadLatest(sigFileInfo.getType());
                    this.printWriter.println(I18N.getResource("signature_update.download.success", sigFileInfo.getVersion()));
                }
            }
        }
        catch (SignatureManagerException e) {
            throw new CommandExecutionException(I18N.getResource("signature_update.download.error", e.getCause().getMessage(), e.getCauseType(), e.getCauseMessage()), e.getCause());
        }
    }

    public void setPrintWriter(PrintWriter printWriter) {
        this.printWriter = printWriter;
    }

    public void setSignatureManager(SignatureManager signatureManager) {
        this.signatureManager = signatureManager;
    }
}

