/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.tiff;

import edu.harvard.hul.ois.jhove.NisoImageMetadata;
import edu.harvard.hul.ois.jhove.module.tiff.IFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffIFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfileClassIT;

public final class TiffProfileClassITCT
extends TiffProfileClassIT {
    public TiffProfileClassITCT() {
        this._profileText = "TIFF/IT-CT (ISO 12639:1998)";
    }

    public boolean satisfiesThisProfile(IFD iFD) {
        if (!super.satisfiesThisProfile(iFD)) {
            return false;
        }
        TiffIFD tiffIFD = (TiffIFD)iFD;
        NisoImageMetadata nisoImageMetadata = tiffIFD.getNisoImageMetadata();
        if (nisoImageMetadata.getBitsPerSample() == null || nisoImageMetadata.getSamplesPerPixel() == -1 || nisoImageMetadata.getSamplingFrequencyUnit() == -1) {
            return false;
        }
        if (!this.satisfiesPhotometricInterpretation(tiffIFD, 5)) {
            return false;
        }
        if (!this.satisfiesCompression(tiffIFD, new int[]{1, 32895})) {
            return false;
        }
        int n = tiffIFD.getInkSet();
        if (n != 1 && n != 2) {
            return false;
        }
        String string = tiffIFD.getColorSequence();
        if ((string == null || "CMYK".equals(string)) && n != 1) {
            return false;
        }
        int n2 = nisoImageMetadata.getSamplesPerPixel();
        int n3 = tiffIFD.getNumberOfInks();
        return n3 == -1 || n3 == n2;
    }
}

