/**
 *	Copyright (C) 2011-2016 Docuteam GmbH
 *
 *	This program is free software: you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 3
 *	as published by the Free Software Foundation.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package ch.docuteam.tools.exception;
/**
 *
 */


import java.util.List;
import java.util.Vector;


/**
 * This abstract class collects {@link Exception}s and offers a public static
 * interface to count, retrieve, and clear the Exceptions.
 *
 * @author denis
 *
 */
public abstract class ExceptionCollector
{

	/**
	 * It's here where the Exceptions are collected (in the order they are inserted).
	 */
	private static List<Exception> All = new Vector<Exception>();

	static void add(Exception e) {
		All.add(e);
	}


	public static Integer size()
	{
		return All.size();
	}


	public static Exception get(Integer i)
	{
		return All.get(i);
	}


	public static List<Exception> getAll()
	{
		return All;
	}


	public static String getAllMessages()
	{
		if (All.isEmpty())		return "[ExceptionCollector(empty)]";

		StringBuilder stringBuilder = new StringBuilder("[ExceptionCollector(")
			.append(All.size())
			.append("):");

		for (Exception e: All)		stringBuilder.append("\n\t").append(e.getMessage());

		return stringBuilder.append("\n]").toString();
	}


	public static String getAllDescriptions()
	{
		if (All.isEmpty())		return "[ExceptionCollector(empty)]";

		StringBuilder stringBuilder = new StringBuilder("[ExceptionCollector(")
			.append(All.size())
			.append("):");

		for (Exception e: All)		stringBuilder.append("\n\t").append(e.getDescription());

		return stringBuilder.append("\n]").toString();
	}


	public static String getAllToString()
	{
		if (All.isEmpty())		return "[ExceptionCollector(empty)]";

		StringBuilder stringBuilder = new StringBuilder("[ExceptionCollector(")
			.append(All.size())
			.append("):");

		for (Exception e: All)		stringBuilder.append("\n\t").append(e.toString());

		return stringBuilder.append("\n]").toString();
	}


	@Deprecated
	/**
	 * @deprecated Use "getAllMessages()" instead.
	 * @return
	 */
	public static String getMessageAll()
	{
		if (All.isEmpty())		return "[ExceptionCollector(empty)]";

		StringBuilder stringBuilder = new StringBuilder("[ExceptionCollector(")
			.append(All.size())
			.append("):");

		for (Exception e: All)		stringBuilder.append("\n\t").append(e.getMessage());

		return stringBuilder.append("\n]").toString();
	}


	public static void printStackTrace()
	{
		if (All.isEmpty())		System.err.println("ExceptionCollector(empty)");
		else
		{
			System.err.println("ExceptionCollector:");

			int i = 1;
			for (Exception e: All)
			{
				System.err.print("#");
				System.err.print(i);
				System.err.print(":");
				System.err.println();
				e.printStackTrace();
				i++;
			}
		}
	}


	public static void clear()
	{
		All = new Vector<Exception>();
	}


	public static Boolean isEmpty()
	{
		return All.isEmpty();
	}


	public static String toStringAll()
	{
		if (All.isEmpty())		return "[ExceptionCollector(empty)]";

		StringBuilder stringBuilder = new StringBuilder("[ExceptionCollector(")
			.append(All.size())
			.append("):");

		for (Exception e: All)		stringBuilder.append("\n\t").append(e.toString());

		return stringBuilder.append("\n]").toString();
	}


	public static void systemOut()
	{
		System.out.println(toStringAll());
	}


}
