/**
 *	Copyright (C) 2011-2016 Docuteam GmbH
 *
 *	This program is free software: you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 3
 *	as published by the Free Software Foundation.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package ch.docuteam.tools.out;
/**
 *
 */

import java.util.Observable;

/**
 * @author denis
 *
 *         An observable object that can send message strings to its observers.
 */
public class ObjectDistributor extends Observable {

	/**
	 * If true, the message is written to SystemOut, too.
	 */
	protected boolean writeToSystemOutToo = true;

	public ObjectDistributor() {
	}

	public ObjectDistributor(boolean writeToSystemOutToo) {
		this.writeToSystemOutToo = writeToSystemOutToo;
	}

	public void distribute(Object object) {
		if (this.writeToSystemOutToo)
			System.out.println(object.toString());

		this.setChanged();
		this.notifyObservers(object);
	}

}
