package ch.docuteam.packer.gui;

import java.awt.Dimension;
import java.awt.Point;

import javax.swing.ImageIcon;

import ch.docuteam.tools.os.OperatingSystem;

public abstract class PackerConstants {

	public static final String OPERATOR = "docuteam packer";
	
	public static final String ZIP_EXT = ".zip";
	public static final String ZIP = "ZIP";
	public static final String DEFAULT_PROPERTY_FILE_NAME = "./config/docuteamPacker.properties";
	public static final String DEFAULT_LEVELS_CONFIG_FILE_NAME = "./config/levels.xml";
	public static final String DEFAULT_METS_NAME = "mets.xml";

	public static final Dimension DEFAULT_SCREEN_SIZE_WITHOUT_WORKSPACE_MANAGER = new Dimension(800, 120);
	public static final Dimension DEFAULT_SCREEN_SIZE_WITH_WORKSPACE_MANAGER = new Dimension(900, 300);
	public static final Point SCREEN_POSITION = new Point(20, 20);
	public static final boolean DO_INITIALLY_OPEN_WORKSPACEMANAGER = true;

	public static final String PROPERTY_FILE_PATH_OS_SUFFIX = OperatingSystem.isWindows() ? ".Win"
			: (OperatingSystem.isMacOSX() ? ".OSX" : ".Linux");
	

	// configs
	public static final String USER_HOME = System.getProperty("user.home");
	public static final String DATE_FORMAT = "dd.MM.yyyy HH:mm:ss";
	public static final String USE_SYSTEM_LOOK_AND_FEEL = "true";
	public static final String NEW_SIP_DEFAULT_DELETE_SOURCES = "false";
	public static final String NEW_SIP_DEFAULTS_TO_ZIPPED = "true";
	public static final String MIGRATE_FILE_KEEP_ORIGINAL = "false";
	public static final String IS_IN_DEVELOP_MODE = "false";

	// Resources
	public static final String DELETE_PNG = "./resources/images/Delete.png";
	public static final String MIGRATE_PNG = "./resources/images/Migrate.png";
	
	public static final String PACKER_PNG = "./resources/images/DocuteamPacker.png";
	public static final String SEARCH_PNG = "./resources/images/Search.png";
	public static final String SAVE_PNG = "./resources/images/Save.png";
	public static final String CHECKSUM_PNG = "./resources/images/Sum.png";
	public static final String INFO_PNG = "./resources/images/Info.png";
	public static final String EXCEPTION_PNG = "./resources/images/Exception.png";
	public static final String HOME_PNG = "./resources/images/Home.png";
	public static final String HELP_PNG = "./resources/images/Help.png";
	public static final String DOWNLOAD_PNG = "./resources/images/Download.png";
	public static final String WORKSPACE_MANAGER_SHOW_PNG = "./resources/images/WorkspaceManagerShow.png";
	public static final String WORKSPACE_MANAGER_HIDE_PNG = "./resources/images/WorkspaceManagerHide.png";
	public static final String OPEN_FOLDER_PNG = "./resources/images/OpenFolder.png";
	public static final String REDISPLAY_PNG = "./resources/images/Redisplay.png";
	public static final String NEW_FROM_TEMPLATE_PNG = "./resources/images/NewFromTemplate.png";
	public static final String OPEN_PNG = "./resources/images/Open.png";
	public static final String CLEAR_PNG = "./resources/images/Clear.png";
	public static final String SEARCH_NEXT_PNG = "./resources/images/SearchNext.png";
	public static final String OPEN_IN_WORKSPACE_PNG = "./resources/images/OpenInWorkspace.png";
//	public static final String _PNG = ;
	
	
	// SIPView
//	public static final String _PNG = ;
	public static final ImageIcon ICON_LEVEL_UNKNOWN = new ImageIcon("./resources/images/LevelUnknown.png");
	public static final ImageIcon ICON_LEVEL_NOT_ALLOWED = new ImageIcon("./resources/images/LevelNotAllowed.png");
	public static final ImageIcon ICON_NOT_ALLOWED_BY_SA = new ImageIcon("./resources/images/Mark.png");
	public static final String URL_PATTERN = "^(https?|ftp|file)://.*";
//	MetadataTableModel
	public static final int CLICK_COUNT_TO_START = 2;
	public static final int EDITABLE_COLUMN_INDEX = 2;
}
