package ch.docuteam.packer.gui.launcher.actions;

import static ch.docuteam.packer.gui.PackerConstants.INFO_PNG;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;

import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;

import ch.docuteam.packer.gui.launcher.AboutView;
import ch.docuteam.packer.gui.launcher.LauncherView;
import ch.docuteam.tools.translations.I18N;

public class AboutAction extends AbstractDocuAction {

	public AboutAction(LauncherView owner) {
		super(I18N.translate("ActionAbout"), new ImageIcon(INFO_PNG), owner);
		putValue(Action.SHORT_DESCRIPTION, I18N.translate("ToolTipAbout"));
		putValue(Action.ACCELERATOR_KEY,
				KeyStroke.getKeyStroke(KeyEvent.VK_I, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
	}

	@Override
	public void actionPerformed(ActionEvent e) {
		openAboutWindow();

	}

	/**
	 * This method has to be public because it is called by the OSXAdapter via
	 * reflection.
	 */
	// TODO hope there is no regression because of above comment
	public void openAboutWindow() {
		new AboutView(owner);
	}
}
