package ch.docuteam.packer.gui.sipView;

import static ch.docuteam.packer.gui.PackerConstants.*;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.URISyntaxException;

import javax.swing.UIManager;
import javax.swing.event.TableModelEvent;

import ch.docuteam.packer.gui.sipView.tableModel.MetadataTableModel;
import ch.docuteam.tools.file.exception.FileIsNotADirectoryException;
import ch.docuteam.tools.gui.JTableWithSpecificCellEditorPerRow;
import ch.docuteam.tools.os.SystemProcess;
import ch.docuteam.tools.os.SystemProcessCantLaunchApplicationException;
import ch.docuteam.tools.os.SystemProcessException;
import ch.docuteam.tools.out.Logger;
import ch.docuteam.tools.translations.I18N;

/**
 * This is a subclass of JTableWithSpecificCellEditorPerRow and overrides the
 * method "public String getToolTipText(MouseEvent e)".
 *
 * @author Docuteam
 *
 */
// TODO what is this class for
public class MetadataTable extends JTableWithSpecificCellEditorPerRow {
	private final int FontSizeMagicNumber = 5;
	private final Font Font = (Font) UIManager.get("Table.font");
	private final int FontSize = Font.getSize() + FontSizeMagicNumber;

	public MetadataTable(MetadataTableModel tableModel, int... toolTipTextColumnIndexes) {
		super(tableModel, toolTipTextColumnIndexes);

		// listen for ctrl-click on the table and – in case the cell contains an
		// url – open it
		addMouseListener(new MouseAdapter() {
			@Override
			public void mousePressed(MouseEvent e) {
				if (e.isControlDown()) {
					MetadataTable target = (MetadataTable) e.getSource();
					String cellValue = target.getModel().getValueAt(target.rowAtPoint(e.getPoint()), target.columnAtPoint(e.getPoint())).toString();
					if (cellValue.matches(URL_PATTERN)) {
						try {
							SystemProcess.openExternally(cellValue);
						} catch (IOException | InterruptedException | SystemProcessException
								| FileIsNotADirectoryException | URISyntaxException
								| SystemProcessCantLaunchApplicationException ex) {
							Logger.error("Could not open URL", ex);
						}
					}
				}
			}
		});

		// Disallow rearranging of columns:
		getTableHeader().setReorderingAllowed(false);
	}

	@Override
	public String getToolTipText(MouseEvent e) {
		switch (columnAtPoint(e.getPoint())) {
		case 0:
			return I18N.translate("ToolTipDynamicMetadataTypes");
		case 1:
			return ((MetadataTableModel) dataModel).getToolTipText(rowAtPoint(e.getPoint()));
		}

		// Otherwise: show the content of the table cell as tooltip text:
		return super.getToolTipText(e);
	}

	@Override
	public void tableChanged(TableModelEvent e) {
		super.tableChanged(e);
		MetadataTableModel model = ((MetadataTableModel) e.getSource());
		for (int i = 0; i < model.getRowCount(); i++) {
			int rows = model.get(i).getLevelMetadataElement().getDisplayRows();
			if (rows == 0)
				rows = 1;
			int requiredRowHeight = FontSize * rows;
			if (requiredRowHeight > 0 && requiredRowHeight != getRowHeight(i))
				setRowHeight(i, requiredRowHeight);
		}
	}

}