package ch.docuteam.packer.gui.sipView;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.List;
import java.util.Vector;

import javax.swing.tree.TreePath;

import org.jdesktop.swingx.JXTreeTable;

import ch.docuteam.darc.mets.structmap.NodeAbstract;

/**
 * This inner class contains the relevant data (the list of dragged Nodes, the
 * dragged Node's parent path, and the source sip path) when dragging Nodes
 * within the tree.
 * 
 * @author denis
 *
 */
public class TreeNodeListTransferable implements Transferable {

	// This is our own data flavor:
	protected static final DataFlavor DocuteamPackerTreeNodeListDataFlavor = new DataFlavor(Object.class,
			"DocuteamPackerTreeNodeListDataFlavor");
	protected static final DataFlavor[] SupportedDataFlavors = { DocuteamPackerTreeNodeListDataFlavor };

	/**
	 * The sipPath is to distinguish the drag source from the drag target.
	 */
	private String sipPath;

	/**
	 * These are the dragged nodes.
	 */
	private List<NodeAbstract> draggedNodes;

	/**
	 * This is the dragged node's parent path. All dragged nodes must have the
	 * same parent - if not, the drag is rejected. I need the parentPath for
	 * refreshing and expanding the path after the drag.
	 */
	private TreePath parentPath;

	protected TreeNodeListTransferable(JXTreeTable treeTable) {
		this.draggedNodes = new Vector<NodeAbstract>();
		for (int i : treeTable.getSelectedRows())
			this.draggedNodes.add((NodeAbstract) (treeTable.getPathForRow(i).getLastPathComponent()));

		// I can safely assume that this.draggedNodes is not empty because - how
		// can one drag 0 nodes?:
		this.sipPath = this.draggedNodes.get(0).getDocument().getSIPFolder();
		this.parentPath = treeTable.getPathForRow(treeTable.getSelectedRows()[0]).getParentPath();
	}

	@Override
	public DataFlavor[] getTransferDataFlavors() {
		return SupportedDataFlavors;
	}

	@Override
	public boolean isDataFlavorSupported(DataFlavor flavor) {
		// This method seems never to be called???
		return DocuteamPackerTreeNodeListDataFlavor.equals(flavor);
	}

	@Override
	public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
		if (DocuteamPackerTreeNodeListDataFlavor.equals(flavor))
			return this;

		throw new UnsupportedFlavorException(flavor);
	}

	public TreePath getParentPath() {
		return parentPath;
	}

	public List<NodeAbstract> getDraggedNodes() {
		return draggedNodes;
	}

	public String getSipPath() {
		return sipPath;
	}

}
