/**
 *	Copyright (C) 2011-2016 Docuteam GmbH
 *
 *	This program is free software: you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 3
 *	as published by the Free Software Foundation.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package ch.docuteam.darc.ead;

import org.dom4j.Node;

import ch.docuteam.darc.common.NodeAbstract;
import ch.docuteam.darc.util.XMLUtil;

/**
 * This abstract class is the superclass of {@link DID}, {@link C}, and
 * {@link ArchDesc}.
 *
 * @author denis
 *
 */
public abstract class EADNodeAbstract extends NodeAbstract {

	protected void deleteParentElementIfEmpty(String xPath) {

		String parentPath = XMLUtil.asParentPath(xPath);
		if (parentPath != null) {

			Node parentNode = this.element.selectSingleNode(parentPath);
			
			if (parentNode != null) {
				deleteElementIfEmpty(parentPath, parentNode);
			}
		}
	}

	protected void deleteElementIfEmpty(String parentPath, Node parentNode) {
		// Look if the parent has EAD nodes as children - if no, delete
		// it and go on checking:
		String nodeContent = parentNode.getText();
		if (nodeContent != null)		nodeContent.trim();
		if (parentNode.selectNodes("EAD:*").isEmpty() && (nodeContent.isEmpty() || nodeContent.equals(null))) {
			parentNode.detach();
			this.deleteParentElementIfEmpty(parentPath);
		}
	}

}
