/**
 *	Copyright (C) 2011-2016 Docuteam GmbH
 *
 *	This program is free software: you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 3
 *	as published by the Free Software Foundation.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package ch.docuteam.darc.ead;

import org.dom4j.Element;

import ch.docuteam.darc.common.NodeAbstract;

/**
 * This class, used by the class {@link Document}, represents the EAD header. It
 * contains solely the eadid.
 *
 * @author denis
 *
 */
public class Header extends NodeAbstract {
	static protected final String XPathEADId = "./EAD:eadid";

	private String eadId;

	private Header(Document document, Element element) {
		this.document = document;
		this.element = element;

		this.eadId = this.getElementText(XPathEADId, true);
	}

	static public Header parse(Document ead, Element parent) {
		return new Header(ead, (Element) parent.selectSingleNode("./EAD:eadheader"));
	}

	public String getEadId() {
		return this.eadId;
	}

	public void setEadId(String eadId) {
		this.eadId = eadId;

		this.element.selectSingleNode(XPathEADId).setText(this.eadId);
		this.document.setIsModified();
	}

	@Override
	public String toString() {
		return new StringBuilder("[eadheader:").append(this.eadId).append("]").toString();
	}

}
