/**
 *	Copyright (C) 2016 Docuteam GmbH
 *
 *	This program is free software: you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 3
 *	as published by the Free Software Foundation.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package ch.docuteam.darc.exceptions;

import ch.docuteam.darc.common.DocumentAbstract;

/**
 * @author iliya
 *
 */
public class NodeFileDeletionNotAllowedException extends Exception {

	private static final long serialVersionUID = -450466084680863470L;

	public NodeFileDeletionNotAllowedException(DocumentAbstract document, String fileName, String fileOp) {
		super("File operation '" + fileOp + "' not allowed with '" + fileName + "' in document: '"
				+ document.getFilePath() + "'");
	}

}
