/**
 *	Copyright (C) 2011-2016 Docuteam GmbH
 *
 *	This program is free software: you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 3
 *	as published by the Free Software Foundation.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package ch.docuteam.darc.mdconfig;

import java.util.*;

import ch.docuteam.tools.out.Tracer;

/**
 * @author denis
 *
 */
public class LevelOfDescriptionSet
{

	//	A Map containing all LevelOfDescriptions. Access key is the level name.
	private Map<String, LevelOfDescription> all = new HashMap<String, LevelOfDescription>();

	//	A List containing all LevelOfDescriptions in their correct order.
	private List<LevelOfDescription> allOrdered = new Vector<LevelOfDescription>();

	/**
	 * @param args
	 */
	public static void main(String[] args)
	{
		LevelOfDescriptionSet levels = new LevelOfDescriptionSet();
		for (LevelOfDescription l: levels.allOrdered)		Tracer.trace(l);

		Tracer.trace(levels.get("Serie"));
		Tracer.trace(levels.get("Denis"));

		for (LevelOfDescription l: levels.allOrdered)		Tracer.trace(l);
	}

	public LevelOfDescriptionSet()
	{
		for (LevelOfDescription l: LevelOfDescription.getAll())
		{
			this.all.put(l.getName(), l);
			this.allOrdered.add(l);
		}
	}

	/**
	 * Create a new Level and insert it into the Levels list, if it is not already there. If it is, just return it.
	 * @param name the name of the new level
	 */
	public LevelOfDescription insertNewIfNecessary(String name)
	{
		if (this.all.containsKey(name))		return this.all.get(name);

		LevelOfDescription newLevel = new LevelOfDescription(name, this.all.size());
		this.all.put(newLevel.getName(), newLevel);
		this.allOrdered.add(newLevel);

		return newLevel;
	}

	public LevelOfDescription getUndefined()
	{
		return this.allOrdered.get(0);
	}


	/**
	 * Return a LevelOfDescription instance with this name. If it is not already in the Levels list, create and insert it.
	 */
	public LevelOfDescription get(String name)
	{
		return this.insertNewIfNecessary(name);
	}

	/**
	 * Return a LevelOfDescription instance at this position.
	 */
	public LevelOfDescription get(int i)
	{
		return this.allOrdered.get(i);
	}

	/**
	 * Return the Levels list in the order the levels were inserted.
	 */
	public List<LevelOfDescription> getAll()
	{
		return this.allOrdered;
	}

	@Override
	public String toString()
	{
		StringBuilder buf = new StringBuilder("[LevelsSet: ");
		for (LevelOfDescription l: this.allOrdered)		buf.append("(").append(l.toString()).append(") ");
		buf.append("]");

		return buf.toString();
	}

}
