/**
 *	Copyright (C) 2011-2016 Docuteam GmbH
 *
 *	This program is free software: you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 3
 *	as published by the Free Software Foundation.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package ch.docuteam.darc.exceptions;

import ch.docuteam.darc.mets.structmap.NodeAbstract;
import ch.docuteam.darc.mets.structmap.NodeAbstract.SubmitStatus;

/**
 * @author denis
 *
 */
public class CantSetSubmitStatusNotAllowedException extends Exception {
	private NodeAbstract node;
	private SubmitStatus currentSubmitStatus;
	private SubmitStatus nextSubmitStatus;

	public CantSetSubmitStatusNotAllowedException(NodeAbstract node, SubmitStatus currentSubmitStatus,
			SubmitStatus nextSubmitStatus) {
		super("Node '" + node.getPathString() + "': Current submit status '" + currentSubmitStatus
				+ "' doesn't allow setting submit status '" + nextSubmitStatus + "'");

		this.node = node;
		this.currentSubmitStatus = currentSubmitStatus;
		this.nextSubmitStatus = nextSubmitStatus;
	}

	public NodeAbstract getNode() {
		return this.node;
	}

	public SubmitStatus getCurrentSubmitStatus() {
		return this.currentSubmitStatus;
	}

	public SubmitStatus getNextSubmitStatus() {
		return this.nextSubmitStatus;
	}

}
