/**
 *	Copyright (C) 2011-2016 Docuteam GmbH
 *
 *	This program is free software: you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 3
 *	as published by the Free Software Foundation.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package ch.docuteam.darc.mdconfig;

import ch.docuteam.darc.exceptions.MetadataElementValidatorException;
import ch.docuteam.darc.mets.structmap.NodeAbstract;
import ch.docuteam.tools.translations.I18N;

/**
 * A MetadataElementValidator that always throws an exception (for testing).
 *
 * @author denis
 *
 */
public class MetadataElementValidatorAlwaysNOK implements MetadataElementValidator {
	@Override
	public void check(String value, NodeAbstract context, MetadataElement metadataElement)
			throws MetadataElementValidatorException {
		throw new MetadataElementValidatorException(I18N.translate_NoCheck("MessageValidatorAlwaysNOK", value,
				I18N.translate_NoCheck(metadataElement.getId())));
	}

}
